%define oname beaker

%def_with python3

Name: python-module-%oname
Version: 1.7.0
Release: alt1.dev.1.1.1
Summary: WSGI middleware layer to provide sessions

Group:  Development/Python
License: BSD
URL: http://pypi.python.org/pypi/Beaker
Source0: http://pypi.python.org/packages/source/B/Beaker/%{name}-%{version}.tar.gz
#BuildPreReq: python-devel python-module-setuptools rpm-build-python
%if_with python3
BuildRequires(pre): rpm-build-python3
# Automatically added by buildreq on Wed Jan 27 2016 (-bi)
# optimized out: python-base python-devel python-modules python-modules-compiler python-modules-ctypes python-modules-email python-modules-encodings python-modules-unittest python3 python3-base
BuildRequires: python-module-setuptools python3-module-setuptools rpm-build-python3

#BuildRequires: python3-devel python3-module-distribute
%endif

BuildArch: noarch

%py_requires Crypto pycryptopp sqlalchemy
%add_python_req_skip jarray javax

%description
Beaker is a caching library that includes Session and Cache objects built on
Myghty's Container API used in MyghtyUtils. WSGI middleware is also included to
manage Session objects and signed cookies.

%if_with python3
%package -n python3-module-%oname
Summary: WSGI middleware layer to provide sessions (Python 3)
Group: Development/Python3
%py3_requires Crypto sqlalchemy
%add_python3_req_skip jarray javax builtins nss

%description -n python3-module-%oname
Beaker is a caching library that includes Session and Cache objects built on
Myghty's Container API used in MyghtyUtils. WSGI middleware is also included to
manage Session objects and signed cookies.
%endif

%prep
%setup
%if_with python3
rm -rf ../python3
cp -a . ../python3
%endif


%build
%python_build
%if_with python3
pushd ../python3
sed -i 's|%_bindir/python|%_bindir/python3|' beaker/crypto/pbkdf2.py
sed -i '2d' beaker/crypto/pbkdf2.py
%python3_build
popd
%endif


%install
%python_install
%if_with python3
pushd ../python3
%python3_install
popd
%endif

%files
%doc *.rst
%python_sitelibdir/beaker/
%python_sitelibdir/Beaker*


%if_with python3
%files -n python3-module-%oname
%doc *.rst
%python3_sitelibdir/beaker/
%python3_sitelibdir/Beaker*
%endif

%changelog
