%define oname chameleon

%def_with python3

Name: python-module-%oname.core
Version: 2.19
Release: alt1.dev.git20141103.1.1
Summary: Chameleon Template Compiler
License: BSD
Group: Development/Python
Url: http://chameleon.repoze.org/
Packager: Eugeny A. Rostovtsev (REAL) <real at altlinux.org>

# https://github.com/malthe/chameleon.git
Source: %name-%version.tar
BuildArch: noarch

#BuildPreReq: python-devel python-module-setuptools-tests
#BuildPreReq: python-module-sphinx-devel
%if_with python3
BuildRequires(pre): rpm-build-python3
BuildRequires(pre): rpm-macros-sphinx
# Automatically added by buildreq on Wed Jan 27 2016 (-bi)
# optimized out: python-base python-devel python-module-PyStemmer python-module-Pygments python-module-babel python-module-cssselect python-module-genshi python-module-jinja2 python-module-jinja2-tests python-module-markupsafe python-module-pytest python-module-pytz python-module-setuptools python-module-six python-module-snowballstemmer python-module-sphinx python-module-sphinx_rtd_theme python-modules python-modules-compiler python-modules-ctypes python-modules-email python-modules-encodings python-modules-json python-modules-logging python-modules-multiprocessing python-modules-unittest python-tools-2to3 python3 python3-base python3-module-pytest python3-module-setuptools
BuildRequires: python-module-alabaster python-module-docutils python-module-html5lib python-module-objects.inv python-module-setuptools-tests python3-module-setuptools-tests rpm-build-python3 time

#BuildRequires: python3-devel python3-module-setuptools-tests
#BuildPreReq: python-tools-2to3
%endif

%description
Attribute language template compiler.

%if_with python3
%package -n python3-module-%oname.core
Summary: Chameleon Template Compiler (Python 3)
Group: Development/Python3

%description -n python3-module-%oname.core
Attribute language template compiler.

%package -n python3-module-%oname.core-tests
Summary: Tests for Chameleon Template Compiler (Python 3)
Group: Development/Python3
Requires: python3-module-%oname.core = %version-%release

%description -n python3-module-%oname.core-tests
Attribute language template compiler.

This package contains tests for Chameleon Template Compiler.
%endif

%package tests
Summary: Tests for Chameleon Template Compiler
Group: Development/Python
Requires: %name = %version-%release

%description tests
Attribute language template compiler.

This package contains tests for Chameleon Template Compiler.

%package pickles
Summary: Pickles for Chameleon Template Compiler
Group: Development/Python

%description pickles
Attribute language template compiler.

This package contains pickles for Chameleon Template Compiler.

%package docs
Summary: Documentation for Chameleon Template Compiler
Group: Development/Documentation

%description docs
Attribute language template compiler.

This package contains documentation for Chameleon Template Compiler.

%prep
%setup
%if_with python3
rm -rf ../python3
cp -a . ../python3
%endif

%prepare_sphinx .
ln -s ../objects.inv docs/

%build
%python_build
%if_with python3
pushd ../python3
find -type f -name '*.py' -exec 2to3 -w '{}' +
%python3_build
popd
%endif

%make pickle
%make html

%install
%python_install
%if_with python3
pushd ../python3
%python3_install
popd
%endif

cp -fR _build/pickle %buildroot%python_sitelibdir/%oname/

%check
python setup.py test
%if_with python3
pushd ../python3
python3 setup.py test
popd
%endif

%files
%doc *.txt *.rst
%python_sitelibdir/*
%exclude %python_sitelibdir/%oname/tests
%exclude %python_sitelibdir/%oname/pickle

%files tests
%python_sitelibdir/%oname/tests

%files pickles
%python_sitelibdir/%oname/pickle

%files docs
%doc _build/html/*

%if_with python3
%files -n python3-module-%oname.core
%doc *.txt *.rst
%python3_sitelibdir/*
%exclude %python3_sitelibdir/%oname/tests

%files -n python3-module-%oname.core-tests
%python3_sitelibdir/%oname/tests
%endif

%changelog
