%define oname click-plugins

%def_with python3

Name: python-module-%oname
Version: 1.0
Release: alt1.git20150720.1
Summary: Register CLI commands via setuptools entry-points
License: BSD
Group: Development/Python
Url: https://pypi.python.org/pypi/click-plugins
Packager: Eugeny A. Rostovtsev (REAL) <real at altlinux.org>

# https://github.com/click-contrib/click-plugins.git
Source: %name-%version.tar
BuildArch: noarch

BuildPreReq: python-devel python-module-setuptools-tests
BuildPreReq: python-module-click-tests python-module-pytest-cov
%if_with python3
BuildRequires(pre): rpm-build-python3
BuildPreReq: python3-devel python3-module-setuptools-tests
BuildPreReq: python3-module-click-tests python3-module-pytest-cov
%endif

%py_provides click_plugins
%py_requires click

%description
An extension module for click to enable registering CLI commands via
setuptools entry-points.

%if_with python3
%package -n python3-module-%oname
Summary: Register CLI commands via setuptools entry-points
Group: Development/Python3
%py3_provides click_plugins
%py3_requires click

%description -n python3-module-%oname
An extension module for click to enable registering CLI commands via
setuptools entry-points.
%endif

%package examples
Summary: Examples for %oname
Group: Development/Documentation
BuildArch: noarch

%description examples
An extension module for click to enable registering CLI commands via
setuptools entry-points.

This package contains examples for %oname.

%prep
%setup

%if_with python3
cp -fR . ../python3
%endif

%build
%python_build_debug

%if_with python3
pushd ../python3
%python3_build_debug
popd
%endif

%install
%python_install

%if_with python3
pushd ../python3
%python3_install
popd
%endif

%check
export LC_ALL=en_US.UTF-8
python setup.py test -v
py.test -vv tests --cov click_plugins --cov-report term-missing
%if_with python3
pushd ../python3
python3 setup.py test -v
py.test-%_python3_version -vv tests --cov click_plugins \
	--cov-report term-missing
popd
%endif

%files
%doc *.txt *.rst
%python_sitelibdir/*
%exclude %python_sitelibdir/tests

%files examples
%doc example/*

%if_with python3
%files -n python3-module-%oname
%doc *.txt *.rst
%python3_sitelibdir/*
%exclude %python3_sitelibdir/tests
%endif

%changelog
