%define oname cligj

%def_with python3

Name: python-module-%oname
Version: 0.2.0
Release: alt1.git20150528.1
Summary: Click params for GeoJSON CLI
License: MIT
Group: Development/Python
Url: https://pypi.python.org/pypi/cligj/
Packager: Eugeny A. Rostovtsev (REAL) <real at altlinux.org>

# https://github.com/mapbox/cligj.git
Source: %name-%version.tar
BuildArch: noarch

BuildPreReq: python-devel python-module-setuptools-tests
BuildPreReq: python-module-click-tests
%if_with python3
BuildRequires(pre): rpm-build-python3
BuildPreReq: python3-devel python3-module-setuptools-tests
BuildPreReq: python3-module-click-tests
%endif

%py_provides %oname
%py_requires click

%description
Common arguments and options for GeoJSON processing commands, using
Click.

%package -n python3-module-%oname
Summary: Click params for GeoJSON CLI
Group: Development/Python3
%py3_provides %oname
%py3_requires click

%description -n python3-module-%oname
Common arguments and options for GeoJSON processing commands, using
Click.

%prep
%setup

%if_with python3
cp -fR . ../python3
%endif

%build
%python_build_debug

%if_with python3
pushd ../python3
%python3_build_debug
popd
%endif

%install
%python_install

%if_with python3
pushd ../python3
%python3_install
popd
%endif

%check
export LC_ALL=en_US.UTF-8
python setup.py test
export PYTHONPATH=$PWD
py.test -vv
%if_with python3
pushd ../python3
python3 setup.py test
export PYTHONPATH=$PWD
py.test-%_python3_version -vv
popd
%endif

%files
%doc *.rst
%python_sitelibdir/*

%if_with python3
%files -n python3-module-%oname
%doc *.rst
%python3_sitelibdir/*
%endif

%changelog
