%define oname colormath

%def_with python3

Name: python-module-%oname
Version: 2.0.2
Release: alt1.git20140701.1
Summary: Python module that abstracts common color math operations
License: GPLv3
Group: Development/Python
Url: http://pypi.python.org/pypi/colormath
Packager: Eugeny A. Rostovtsev (REAL) <real at altlinux.org>

# https://github.com/gtaylor/python-colormath.git
Source: %name-%version.tar
BuildArch: noarch

BuildPreReq: python-devel python-module-setuptools
%if_with python3
BuildRequires(pre): rpm-build-python3
BuildRequires: python3-devel python3-module-setuptools
%endif

%description
This module implements a large number of different color operations such
as color space conversions, Delta E, and density to spectral.

%if_with python3
%package -n python3-module-%oname
Summary: Python 3 module that abstracts common color math operations
Group: Development/Python3

%description -n python3-module-%oname
This module implements a large number of different color operations such
as color space conversions, Delta E, and density to spectral.
%endif

%prep
%setup
%if_with python3
rm -rf ../python3
cp -a . ../python3
%endif

%build
%python_build_debug
%if_with python3
pushd ../python3
%python3_build_debug
popd
%endif

%install
%python_install
%if_with python3
pushd ../python3
%python3_install
popd
%endif

%files
%doc *.txt
%python_sitelibdir/*

%if_with python3
%files -n python3-module-%oname
%doc *.txt examples tests
%python3_sitelibdir/*
%endif

%changelog
