%define oname coverage

%def_with python3

Name: python-module-%oname
Version: 4.0
Release: alt1.a7.git20150730.1.1
Summary: A tool for measuring code coverage of Python programs
License: BSD
Group: Development/Python
Url: http://nedbatchelder.com/code/coverage/
Packager: Eugeny A. Rostovtsev (REAL) <real at altlinux.org>

# hg clone http://bitbucket.org/ned/coveragepy
Source: %oname-%version.tar.gz

BuildRequires(pre): rpm-build-python
#BuildPreReq: python-devel python-module-sphinx python-module-Pygments
#BuildPreReq: python-module-enchant libenchant
#BuildPreReq: python-module-sphinxcontrib-napoleon
#BuildPreReq: python-module-sphinxcontrib-spelling

# Automatically added by buildreq on Wed Jan 27 2016 (-bi)
# optimized out: bzr elfutils python-base python-devel python-module-Paver python-module-PyStemmer python-module-Pygments python-module-babel python-module-cffi python-module-cryptography python-module-cssselect python-module-docutils python-module-enchant python-module-enum34 python-module-genshi python-module-jinja2 python-module-jinja2-tests python-module-markupsafe python-module-mimeparse python-module-pbr python-module-pyasn1 python-module-pytz python-module-serial python-module-setuptools python-module-six python-module-snowballstemmer python-module-sphinx python-module-sphinx_rtd_theme python-module-sphinxcontrib python-module-twisted-core python-module-unittest2 python-module-zope.interface python-modules python-modules-compiler python-modules-ctypes python-modules-email python-modules-encodings python-modules-json python-modules-logging python-modules-multiprocessing python-modules-unittest python-modules-xml python3 python3-base
BuildRequires: libenchant python-module-alabaster python-module-html5lib python-module-sphinxcontrib-napoleon python-module-sphinxcontrib-spelling python3-devel python3-module-setuptools rpm-build-python3 time

%description
Coverage.py is a tool for measuring code coverage of Python programs. It
monitors your program, noting which parts of the code have been
executed, then analyzes the source to identify code that could have been
executed but was not.

Coverage measurement is typically used to gauge the effectiveness of
tests. It can show which parts of your product code are being exercised
by tests, and which are not.

%package doc
Summary: Documentation for Coverage python module
Group: Development/Documentation
BuildArch: noarch

%description doc
Coverage.py is a tool for measuring code coverage of Python programs. It
monitors your program, noting which parts of the code have been
executed, then analyzes the source to identify code that could have been
executed but was not.

This package contains documentation for Coverage.py.

%package pickles
Summary: Pickles for Coverage python module
Group: Development/Python

%description pickles
Coverage.py is a tool for measuring code coverage of Python programs. It
monitors your program, noting which parts of the code have been
executed, then analyzes the source to identify code that could have been
executed but was not.

This package contains pickles for Coverage.py.

%if_with python3
%package -n python3-module-%oname
Summary: A tool for measuring code coverage of Python3 programs
Group: Development/Python3
BuildRequires(pre): rpm-build-python3
#BuildRequires: python3-devel python3-module-distribute

%description -n python3-module-%oname
Coverage.py is a tool for measuring code coverage of Python programs. It
monitors your program, noting which parts of the code have been
executed, then analyzes the source to identify code that could have been
executed but was not.

Coverage measurement is typically used to gauge the effectiveness of
tests. It can show which parts of your product code are being exercised
by tests, and which are not.
%endif

%prep
%setup
%if_with python3
rm -rf ../python3
cp -a . ../python3
%endif

%build
%add_optflags -fno-strict-aliasing
%python_build_debug

export PYTHONPATH=$PWD
%make_build dochtml
%make_build pickle

%if_with python3
pushd ../python3
%python3_build
popd
%endif

%install
%if_with python3
pushd ../python3
%python3_install
popd
mv %buildroot%_bindir/coverage %buildroot%_bindir/coverage3
%endif

%python_install

install -d %buildroot%python_sitelibdir/%oname/lab
install -p -m644 lab/* %buildroot%python_sitelibdir/%oname/lab

install -d %buildroot%_docdir/%name
cp -fR doc/_build/html/* %buildroot%_docdir/%name/
cp -fR doc/_build/pickle %buildroot%python_sitelibdir/%oname/

%files
%doc CHANGES.txt README.txt TODO.txt
%python_sitelibdir/*
%exclude %python_sitelibdir/%oname/pickle
%_bindir/*
%exclude %_bindir/coverage3
%exclude %_bindir/coverage-%_python3_version

%files doc
%_docdir/%name

%files pickles
%python_sitelibdir/%oname/pickle

%if_with python3
%files -n python3-module-%oname
%_bindir/coverage3
%_bindir/coverage-%_python3_version
%python3_sitelibdir/*.egg-info
%python3_sitelibdir/%oname
%endif

%changelog
