%define oname cryptography
%def_with python3

Name: python-module-%oname
Version: 2.0.0
Release: alt0.M80P.1

Summary: Cryptographic recipes and primitives to Python developers.

License: %asl
Group: Development/Python
Url: https://pypi.python.org/pypi/cryptography/
Packager: Vladimir Didenko <cow@altlinux.org>
# Source-url: https://pypi.python.org/packages/source/c/cryptography/%oname-%version.tar.gz
Source: %oname-%version.tar

#BuildPreReq: rpm-build-python rpm-build-licenses
BuildRequires(pre): rpm-build-licenses
# Automatically added by buildreq on Fri Jan 29 2016 (-bi)
# optimized out: elfutils libcom_err-devel libkrb5-devel python-base python-devel python-module-pycparser python-module-pytest python-module-setuptools python-modules python-modules-compiler python-modules-ctypes python-modules-email python-modules-encodings python-modules-unittest python3 python3-base python3-module-pycparser python3-module-pytest python3-module-setuptools
BuildRequires: libssl-devel python-module-cffi python-module-enum34 python-module-pyasn1 python-module-setuptools-tests python3-devel python3-module-cffi python3-module-enum34 python3-module-setuptools-tests rpm-build-python3

#BuildRequires: python-devel python-module-distribute python-module-setuptools-tests
#BuildRequires: python-module-six python-module-cffi python-module-pycparser
#BuildRequires: libssl-devel
#BuildRequires: python-module-pyasn1
#BuildRequires: python-module-enum34
#BuildRequires: python-module-ipaddress
#BuildRequires: python-module-idna
%if_with python3
BuildRequires(pre): rpm-build-python3
#BuildRequires: python3-devel python3-module-distribute python3-module-setuptools-tests
#BuildRequires: python3-module-six python3-module-cffi python3-module-pycparser
#BuildRequires: python3-module-pyasn1
#BuildRequires: python3-module-enum34
#BuildRequires: python3-module-idna
%endif

Requires: python-module-cffi >= 1.7

%setup_python_module %oname

%description
cryptography is a package which provides cryptographic recipes and primitives to Python developers.
Our goal is for it to be your "cryptographic standard library". cryptography includes both high level
recipes, and low level interfaces to common cryptographic algorithms such as symmetric ciphers, message
digests and key derivation functions.


%if_with python3
%package -n python3-module-%oname
Summary: Cryptographic recipes and primitives to Python developers (Python 3).
Group: Development/Python3
Requires: python3-module-cffi >= 1.7

%description -n python3-module-%oname
cryptography is a package which provides cryptographic recipes and primitives to Python developers.
Our goal is for it to be your "cryptographic standard library". cryptography includes both high level
recipes, and low level interfaces to common cryptographic algorithms such as symmetric ciphers, message
digests and key derivation functions.
%endif


%prep
%setup -n %oname-%version

%if_with python3
rm -rf ../python3
cp -a . ../python3
%endif

%build
%python_build

%if_with python3
pushd ../python3
%python3_build
popd
%endif

%install
%python_install

%if_with python3
pushd ../python3
%python3_install
popd

%filter_from_requires /python3[(]cryptography.hazmat.bindings._commoncrypto[)]/d
%endif

%files
%doc AUTHORS.rst  CHANGELOG.rst  CONTRIBUTING.rst  README.rst
%python_sitelibdir/%oname/
%python_sitelibdir/*.egg-info

%if_with python3
%files -n python3-module-%oname
%python3_sitelibdir/%oname/
%python3_sitelibdir/*.egg-*
%endif

%changelog
