%define component designateclient
%def_without python3

Name: python-module-%component
Version: 2.1.0
Release: alt0.M80P.1
Summary: Openstack DNS (Designate) API Client
License: Apache-2.0
Group: Development/Python
Url: http://launchpad.net/python-designateclient
Source: %name-%version.tar

BuildArch:  noarch

BuildRequires: python-devel
BuildRequires: python-module-setuptools
BuildRequires: python-module-pbr >= 1.6
BuildRequires: python-module-d2to1
BuildRequires: python-module-keystoneclient >= 1.6.0
BuildRequires: python-module-requests >= 2.5.2
BuildRequires: python-module-six >= 1.9.0
BuildRequires: python-module-stevedore >= 1.5.0
BuildRequires: python-module-cliff >= 1.14.0
BuildRequires: python-module-jsonschema >= 2.0.0
BuildRequires: python-module-debtcollector >= 0.3.0
BuildRequires: python-module-sphinx
BuildRequires: python-module-oslosphinx
BuildRequires: fdupes

%if_with python3
BuildRequires(pre): rpm-build-python3
BuildRequires: python3-devel
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-pbr >= 1.6
BuildRequires: python3-module-d2to1
BuildRequires: python3-module-keystoneclient >= 1.6.0
BuildRequires: python3-module-requests >= 2.5.2
BuildRequires: python3-module-six >= 1.9.0
BuildRequires: python3-module-stevedore >= 1.5.0
BuildRequires: python3-module-cliff >= 1.14.0
BuildRequires: python3-module-jsonschema >= 2.0.0
BuildRequires: python3-module-debtcollector >= 0.3.0
BuildRequires: python3-module-sphinx
BuildRequires: python3-module-oslosphinx
%endif

%description
This is a client for the OpenStack Designate API. There's a Python API
(the designateclient module), and a command-line tool (designate).

%if_with python3
%package -n python3-module-%component
Summary:   Openstack DNS (Designate) API Client
Group: Development/Python3

%description -n python3-module-%component
This is a client for the OpenStack Designate API. There's a Python API
(the designateclient module), and a command-line tool (designate).
%endif

%package doc
Summary: Openstack DNS (Designate) API Client - Documentation
Group: Development/Documentation

%description doc
This package contains documentation files for %name.

%prep
%setup
# Let RPM handle the dependencies
rm -f test-requirements.txt requirements.txt

# Remove bundled egg-info
rm -rf python_designateclient.egg-info
%if_with python3
rm -rf ../python3
cp -a . ../python3
%endif

%build
%python_build
%if_with python3
pushd ../python3
%python3_build
popd
%endif


%install
%if_with python3
pushd ../python3
%python3_install
popd
mv %buildroot%_bindir/designate %buildroot%_bindir/python3-designate
%endif

%python_install

# Delete tests
rm -fr %buildroot%python_sitelibdir/*/tests
rm -fr %buildroot%python3_sitelibdir/*/tests

# Build HTML docs and man page
export PYTHONPATH="$( pwd ):$PYTHONPATH"
sphinx-build -b html doc/source html

# Fix hidden-file-or-dir warnings
rm -fr html/.doctrees html/.buildinfo


%files
%doc README.rst
%_bindir/designate
%python_sitelibdir/*

%if_with python3
%files -n python3-module-%component
%_bindir/python3-designate
%python3_sitelibdir/*
%endif

%files doc
%doc html

%changelog
