
Name:           python-module-django-openstack-auth
Version:        2.2.1
Release:        alt1
Summary:        Django authentication backend for OpenStack Keystone
Group:          Development/Python

License:        BSD
URL:            http://pypi.python.org/pypi/django_openstack_auth/
Source0:        %name-%version.tar

BuildArch:      noarch

BuildRequires: python-devel
BuildRequires: python-module-setuptools
BuildRequires: python-module-sphinx
BuildRequires: python-module-oslosphinx
BuildRequires: python-module-pbr >= 1.6
BuildRequires: python-module-six >= 1.9.0
BuildRequires: python-module-django >= 1.8
BuildRequires: python-module-oslo.config >= 3.7.0
BuildRequires: python-module-oslo.policy >= 0.5.0
BuildRequires: python-module-keystoneclient >= 1.6.0
BuildRequires: python-module-keystoneauth1 >= 2.1.0

BuildRequires: python-module-django-dbbackend-sqlite3

Requires: python-module-django
Requires: python-module-oslo.config >= 2.3.0
Requires: python-module-oslo.policy >= 0.5.0
Requires: python-module-keystoneclient >= 1.6.0
Requires: python-module-keystoneauth1 >= 2.1.0

%description
Django OpenStack Auth is a pluggable Django authentication backend that
works with Django's ``contrib.auth`` framework to authenticate a user against
OpenStack's Keystone Identity API.

The current version is designed to work with the
Keystone V2 API.

%prep
%setup

# Remove the requirements file so that pbr hooks don't add it
# to distutils requires_dist config
rm -f {test-,}requirements.txt

%build
# generate translations
cd openstack_auth && django-admin compilemessages && cd ..

# remove unnecessary .po files
find . -name "django.po" -exec rm -f '{}' \;

%python_build

# generate html docs
PYTHONPATH=.:$PYTHONPATH sphinx-build doc/source html

%install
%python_install

cp -r openstack_auth/locale %buildroot%python_sitelibdir/openstack_auth

%find_lang django

# don't include tests in the RPM
rm -rf %buildroot/%python_sitelibdir/openstack_auth/tests
# 
# %check
# %{__python} setup.py test

%files -f django.lang
%doc LICENSE
%python_sitelibdir/*

%changelog
