# This spec is backported to ALTLinux p8 automatically by rpmbph script from etersoft-build-utils.
#
%define modulename dns

# Testing requires network access
#def_without check

Name: python-module-%modulename
Version: 1.15.0
Release: alt0.M80P.1

Summary: DNS toolkit

License: BSD-like
Group: Development/Python
Url: http://www.dnspython.org

Packager: Python Development Team <python at packages.altlinux.org>

BuildArch: noarch

# git://github.com/rthalley/dnspython.git
# Source-url: http://www.dnspython.org/kits/%version/dnspython-%version.tar.gz
Source: %name-%version.tar

Provides: python-module-dnspython = %EVR
Obsoletes: python-module-dnspython <= 1.10.0-alt1

%setup_python_module %modulename

#BuildPreReq: python-module-epydoc

BuildRequires: python-devel python-module-setuptools

%description
dnspython is a DNS toolkit for Python. It supports almost all
record types. It can be used for queries, zone transfers, and dynamic
updates.  It supports TSIG authenticated messages and EDNS0.

dnspython provides both high and low level access to DNS. The high
level classes perform queries for data of a given name, type, and
class, and return an answer set.  The low level classes allow
direct manipulation of DNS zones, messages, names, and records.

%prep
%setup
rm -f examples/._*

%build
%python_build
#make_build doc

%install
%python_install

%if_with check
%check
pushd tests
%make PYTHONPATH="../:$PYTHONPATH" check
popd
%endif

%files
%doc examples/ ChangeLog LICENSE
%python_sitelibdir/*

%changelog
