%define oname fs

%def_without docs

Name: python-module-%oname
Version: 0.5.5a1
Release: alt1
Summary: Filesystem abstraction layer
License: BSD
Group: Development/Python
Url: https://pypi.python.org/pypi/fs/

# https://github.com/PyFilesystem/pyfilesystem
Source: %name-%version.tar
Patch: %name-%version-%release.patch
BuildArch: noarch

#BuildPreReq: python-devel python-module-setuptools-tests
#BuildPreReq: python-module-wx python-module-dexml
#BuildPreReq: python-module-django
# for test_expose in %%check:
BuildPreReq: python-module-paramiko
# for test_ftpfs in %%check:
BuildPreReq: python-module-pyftpdlib
# for FUSE tests (which are not run in hasher anyway, but some setup is done)
BuildPreReq: libfuse
# for archivefs tests in %%check:
BuildPreReq: python-module-libarchive
#BuildPreReq: python-module-sphinx-devel
#BuildPreReq: python-module-sphinxcontrib-spelling

# upstream commentary:
#
#  fs/tests/test_s3fs:  testcases for the S3FS module
#
# These tests are set up to be skipped by default, since they're very slow,
# require a valid AWS account, and cost money.
#
# ALT: the availability of boto module determines whether they are run.
# (Thanks to the annotations from https://github.com/smartfile/pyfilesystem .)
BuildConflicts: python-module-boto

%py_provides %oname

BuildRequires(pre): rpm-macros-sphinx
# Automatically added by buildreq on Thu Jan 28 2016 (-bi)
# optimized out: python-base python-devel python-module-PyStemmer python-module-Pygments python-module-babel python-module-cffi python-module-cryptography python-module-cssselect python-module-docutils python-module-enum34 python-module-genshi python-module-jinja2 python-module-numpy python-module-psycopg2 python-module-pyasn1 python-module-pytest python-module-pytz python-module-setuptools python-module-snowballstemmer python-module-sphinx python-module-yaml python-modules python-modules-compiler python-modules-ctypes python-modules-email python-modules-encodings python-modules-unittest python-modules-wsgiref python3 python3-base python3-module-chardet python3-module-psycopg2 python3-module-pytest python3-module-setuptools python3-module-yaml python3-module-yieldfrom.http.client python3-module-yieldfrom.urllib3
BuildRequires: python-module-chardet python-module-django python-module-ecdsa python-module-html5lib python-module-ndg-httpsclient python-module-ntlm python-module-pycrypto python-module-setuptools-tests python-module-sphinxcontrib-spelling python-module-wx

%description
PyFilesystem is an abstraction layer for filesystems. In the same way
that Python's file-like objects provide a common way of accessing files,
PyFilesystem provides a common way of accessing entire filesystems. You
can write platform-independent code to work with local files, that also
works with any of the supported filesystems (zip, ftp, S3 etc.).

%package tests
Summary: Tests for %oname
Group: Development/Python
Requires: %name = %EVR

%description tests
PyFilesystem is an abstraction layer for filesystems. In the same way
that Python's file-like objects provide a common way of accessing files,
PyFilesystem provides a common way of accessing entire filesystems. You
can write platform-independent code to work with local files, that also
works with any of the supported filesystems (zip, ftp, S3 etc.).

This package contains tests for %oname.

%package pickles
Summary: Pickles for %oname
Group: Development/Python

%description pickles
PyFilesystem is an abstraction layer for filesystems. In the same way
that Python's file-like objects provide a common way of accessing files,
PyFilesystem provides a common way of accessing entire filesystems. You
can write platform-independent code to work with local files, that also
works with any of the supported filesystems (zip, ftp, S3 etc.).

This package contains pickles for %oname.

%package docs
Summary: Documentation for %oname
Group: Development/Documentation
BuildArch: noarch

%description docs
PyFilesystem is an abstraction layer for filesystems. In the same way
that Python's file-like objects provide a common way of accessing files,
PyFilesystem provides a common way of accessing entire filesystems. You
can write platform-independent code to work with local files, that also
works with any of the supported filesystems (zip, ftp, S3 etc.).

This package contains documentation for %oname.

%prep
%setup
%patch -p1

%if_with docs
%prepare_sphinx .
ln -s ../objects.inv docs/
%endif

%build
%python_build_debug

%install
%python_install

%if_with docs
export PYTHONPATH=%buildroot%python_sitelibdir
%make -C docs pickle
%make -C docs html

cp -fR docs/_build/pickle %buildroot%python_sitelibdir/%oname/
%endif

%check
# for filenames:
export LC_ALL=en_US.utf8
# for print statements:
export PYTHONIOENCODING=UTF-8
python setup.py test

%files
%doc AUTHORS *.txt
%_bindir/*
%python_sitelibdir/*
%exclude %python_sitelibdir/*/tests
%exclude %python_sitelibdir/*/*/*/test*
%if_with docs
%exclude %python_sitelibdir/*/pickle
%endif

%if_with docs
%files pickles
%python_sitelibdir/*/pickle

%files docs
%doc docs/_build/html/*
%endif

%files tests
%python_sitelibdir/*/tests
%python_sitelibdir/*/*/*/test*

%changelog
