%def_with python3
%define sname heatclient

Name: python-module-%sname
Version: 1.1.0
Release: alt0.M80P.1
Summary: Python API and CLI for OpenStack Heat

Group: Development/Python
License: ASL 2.0
Url: http://pypi.python.org/pypi/python-%sname
Source: %name-%version.tar

BuildArch: noarch

BuildRequires: git
BuildRequires: python-module-setuptools
BuildRequires: python-module-pbr

Requires: python-module-iso8601
Requires: python-module-keystoneauth1
Requires: python-module-oslo-i18n

%if_with python3
BuildRequires(pre): rpm-build-python3
%endif

%description
This is a client for the OpenStack Heat API. There's a Python API (the
heatclient module), and a command-line script (heat). Each implements 100 percent of
the OpenStack Heat API.

%if_with python3
%package -n python3-module-%sname
Summary:    Python API and CLI for OpenStack Heat
Group: Development/Python3

BuildRequires: python3-module-setuptools
BuildRequires: python3-module-pbr

Requires: python3-module-iso8601
Requires: python3-module-keystoneauth1
Requires: python3-module-oslo-i18n

%description -n python3-module-%sname
This is a client for the OpenStack Heat API. There's a Python API (the
heatclient module), and a command-line script (heat). Each implements 100 percent of
the OpenStack Heat API.
%endif

%package doc
Summary: Documentation for OpenStack Heat API Client
Group: Development/Documentation

BuildRequires: python-module-sphinx
BuildRequires: python-module-oslosphinx

%description doc
This is a client for the OpenStack Heat API. There's a Python API (the
heatclient module), and a command-line script (heat). Each implements 100 percent of
the OpenStack Heat API.

This package contains auto-generated documentation.

%prep
%setup

# Remove the requirements file so that pbr hooks don't add it
# to distutils requires_dist config.
rm -rf {test-,}requirements.txt tools/{pip,test}-requires
%if_with python3
rm -rf ../python3
cp -a . ../python3
%endif

%build
%python_build
%if_with python3
pushd ../python3
%python3_build
popd
%endif

%install
%if_with python3
pushd ../python3
%python3_install
popd
mv %buildroot%_bindir/heat %buildroot%_bindir/python3-heat
%endif

%python_install
echo "%version" > %buildroot%python_sitelibdir/heatclient/versioninfo
echo "%version" > %buildroot%python3_sitelibdir/heatclient/versioninfo

mkdir -p %buildroot%_sysconfdir/bash_completion.d
install -pm 644 tools/heat.bash_completion \
    %buildroot%_sysconfdir/bash_completion.d/heat

# Delete tests
rm -fr %buildroot%python_sitelibdir/heatclient/tests
rm -fr %buildroot%python3_sitelibdir/heatclient/tests

export PYTHONPATH="$( pwd ):$PYTHONPATH"
sphinx-build -b html doc/source html

# generate man page
sphinx-build -b man doc/source man
install -p -D -m 644 man/heat.1 %buildroot%_mandir/man1/heat.1

# Fix hidden-file-or-dir warnings
rm -fr html/.doctrees html/.buildinfo

%files
%doc LICENSE README.rst
%_bindir/heat
%python_sitelibdir/*
%_sysconfdir/bash_completion.d
%_man1dir/*

%if_with python3
%files -n python3-module-%sname
%_bindir/python3-heat
%python3_sitelibdir/*
%_sysconfdir/bash_completion.d
%_man1dir/*
%endif

%files doc
%doc html

%changelog
