# This spec is backported to ALTLinux p8 automatically by rpmbph script from etersoft-build-utils.
#
%define module_name html5lib

%def_with python3
%def_without doc

Name: python-module-%module_name
Epoch: 1
Version: 0.999999999
Release: alt1.M80P.2

Summary: Library for working with HTML5 documents

License: MIT
Group: Development/Python
BuildArch: noarch
Url: https://github.com/html5lib/html5lib-python

# Source-url: https://github.com/html5lib/html5lib-python/archive/%version.tar.gz
Source: %module_name-%version.tar

%{?_with_doc:BuildRequires(pre): rpm-macros-sphinx}
# Automatically added by buildreq on Thu Jan 28 2016 (-bi)
# optimized out: python-base python-modules python-modules-compiler python-modules-email python-modules-encodings python-modules-logging python3 python3-base
BuildRequires: python-devel python-tools-2to3 rpm-build-python3 time
BuildRequires: python-module-setuptools >= 18.5

%setup_python_module %module_name

%if_with python3
BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-setuptools >= 18.5
%endif

%description
A ruby/python based HTML parser/tokenizer based on the WHATWG
HTML5 specification for maximum compatibility with major
desktop web browsers.

%package tests
Summary: Tests for html5lib
Group: Development/Python
Requires: %name = %EVR

%description tests
A ruby/python based HTML parser/tokenizer based on the WHATWG
HTML5 specification for maximum compatibility with major
desktop web browsers.

This package contains tests for html5lib.

%package pickles
Summary: Pickles for html5lib
Group: Development/Python

%description pickles
A ruby/python based HTML parser/tokenizer based on the WHATWG
HTML5 specification for maximum compatibility with major
desktop web browsers.

This package contains pickles for html5lib.

%package doc
Summary: Documentation for html5lib
Group: Development/Documentation

%description doc
A ruby/python based HTML parser/tokenizer based on the WHATWG
HTML5 specification for maximum compatibility with major
desktop web browsers.

This package contains documentation for html5lib.

%if_with python3
%package -n python3-module-%module_name
Summary: Library for working with HTML5 documents (Python 3)
Group: Development/Python3

%description -n python3-module-%module_name
A ruby/python based HTML parser/tokenizer based on the WHATWG
HTML5 specification for maximum compatibility with major
desktop web browsers.

%package -n python3-module-%module_name-tests
Summary: Tests for html5lib (Python 3)
Group: Development/Python3
Requires: python3-module-%module_name = %EVR

%description -n python3-module-%module_name-tests
A ruby/python based HTML parser/tokenizer based on the WHATWG
HTML5 specification for maximum compatibility with major
desktop web browsers.

This package contains tests for html5lib.
%endif

%prep
%setup -n %module_name-%version
%if_with python3
rm -rf ../python3
cp -a . ../python3
%endif

%if_with doc
%prepare_sphinx .
ln -s ../objects.inv doc/
%endif

%build
%python_build
%if_with python3
pushd ../python3
find -type f -name '*.py' -exec 2to3 -w '{}' +
# restore unichr after 2to3 (ALT bug 33854), python3 tests still are broken
%__subst "s|from six import chr as chr|from six import unichr as chr|g" html5lib/_tokenizer.py
%python3_build
popd
%endif

%if_with doc
%make -C doc pickle
%make -C doc html
%endif

%install
%python_install
%if_with python3
pushd ../python3
%python3_install
popd
%endif

%if_with doc
cp -fR doc/_build/pickle %buildroot%python_sitelibdir/%module_name/
%endif

%files
%doc README.rst
#exclude %python_sitelibdir/*/tests
%python_sitelibdir/*
%if_with doc
%exclude %python_sitelibdir/*/pickle
%endif

#files tests
#python_sitelibdir/*/tests

%if_with doc
%files pickles
%python_sitelibdir/*/pickle

%files doc
%doc doc/_build/html/*
%endif

%if_with python3
%files -n python3-module-%module_name
%python3_sitelibdir/*
#exclude %python3_sitelibdir/*/tests

#files -n python3-module-%module_name-tests
#python3_sitelibdir/*/tests
%endif

%changelog
