%define modulename icu

%def_with python3

Name: python-module-%modulename
Version: 1.9.2
Release: alt1.1

%setup_python_module %modulename

Summary: Python extension wrapping the ICU C++ API
License: ISC-style
Group: Development/Python

Url: http://pyicu.osafoundation.org/
Packager: Kirill Maslinsky <kirill@altlinux.org>

%define srcname PyICU-%version
# http://pypi.python.org/packages/source/P/PyICU/%srcname.tar.gz
# VCS: https://github.com/ovalhub/pyicu.git
Source: %name-%version.tar

BuildRequires: gcc-c++ libicu-devel python-devel
BuildPreReq: python-module-setuptools
%if_with python3
BuildRequires(pre): rpm-build-python3
BuildPreReq: python3-devel python3-module-setuptools
%endif

%description
PyICU - Python extension wrapping the ICU C++ API.

%package -n python3-module-%modulename
Summary: Python extension wrapping the ICU C++ API
Group: Development/Python3

%description -n python3-module-%modulename
PyICU - Python extension wrapping the ICU C++ API.

%prep
%setup

%if_with python3
cp -fR . ../python3
%endif

%build
%python_build

%if_with python3
pushd ../python3
%python3_build
popd
%endif

%install
%python_install

%if_with python3
pushd ../python3
%python3_install
popd
%endif

%files
%python_sitelibdir/*
#%exclude %python_sitelibdir/*.egg-info
%doc CREDITS README* CHANGES samples/

%if_with python3
%files -n python3-module-%modulename
%python3_sitelibdir/*
#%exclude %python3_sitelibdir/*.egg-info
%doc CREDITS README* CHANGES samples/
%endif

%changelog
