%def_with python3

Name:       python-module-keystoneclient
Version:    2.3.1
Release:    alt1
Summary:    Client library for OpenStack Identity API
License:    ASL 2.0
URL:        http://pypi.python.org/pypi/%{name}
Source:    %name-%version.tar
Group:      Development/Python

BuildArch:  noarch

BuildRequires: python-devel
BuildRequires: python-module-setuptools
BuildRequires: python-module-pbr >= 1.6
BuildRequires: python-module-iso8601 >= 0.1.9
BuildRequires: python-module-debtcollector >= 1.2.0
BuildRequires: python-module-keystoneauth1 >= 2.1.0
BuildRequires: python-module-oslo.config >= 3.7.0
BuildRequires: python-module-oslo.i18n >= 2.1.0
BuildRequires: python-module-oslo.serialization >= 1.10.0
BuildRequires: python-module-oslo.utils >= 3.5.0
BuildRequires: python-module-positional >= 1.0.1
BuildRequires: python-module-prettytable >= 0.7
BuildRequires: python-module-requests >= 2.8.1
BuildRequires: python-module-six >= 1.9.0
BuildRequires: python-module-stevedore >= 1.5.0

BuildRequires: python-module-sphinx
BuildRequires: python-module-oslosphinx
BuildRequires: python-module-reno >= 0.1.1

%if_with python3
BuildRequires(pre): rpm-build-python3
BuildRequires: python3-devel
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-pbr
BuildRequires: python3-module-iso8601 >= 0.1.9
BuildRequires: python3-module-debtcollector >= 1.2.0
BuildRequires: python3-module-keystoneauth1 >= 2.1.0
BuildRequires: python3-module-oslo.config >= 3.7.0
BuildRequires: python3-module-oslo.i18n >= 2.1.0
BuildRequires: python3-module-oslo.serialization >= 1.10.0
BuildRequires: python3-module-oslo.utils >= 3.5.0
BuildRequires: python3-module-positional >= 1.0.1
BuildRequires: python3-module-prettytable >= 0.7
BuildRequires: python3-module-requests >= 2.8.1
BuildRequires: python3-module-six >= 1.9.0
BuildRequires: python3-module-stevedore >= 1.5.0
%endif

%description
Client library and command line utility for interacting with Openstack
Identity API.

%if_with python3
%package -n python3-module-keystoneclient
Summary:    Client library for OpenStack Identity API
Group: Development/Python3

%description -n python3-module-keystoneclient
Client library and command line utility for interacting with Openstack
Identity API.
%endif

%package doc
Summary:    Documentation for OpenStack Identity API Client
Group:  Development/Documentation

%description doc
Documentation for the client library for interacting with Openstack
Identity API.

%prep
%setup

# Let RPM handle the dependencies
rm -f test-requirements.txt requirements.txt

%if_with python3
rm -rf ../python3
cp -a . ../python3
%endif

%build
%python_build
%if_with python3
pushd ../python3
%python3_build
popd
%endif

# disabling git call for last modification date from git repo
sed '/^html_last_updated_fmt.*/,/.)/ s/^/#/' -i doc/source/conf.py
python setup.py build_sphinx
rm -f doc/build/html/.buildinfo

%install
%if_with python3
pushd ../python3
%python3_install
popd
mv %buildroot%_bindir/keystone %buildroot%_bindir/python3-keystone
%endif

%python_install
install -p -D -m 644 tools/keystone.bash_completion %buildroot%_sysconfdir/bash_completion.d/keystone.bash_completion

# Delete tests
rm -fr %buildroot%python_sitelibdir/keystoneclient/tests
rm -fr %buildroot%python3_sitelibdir/keystoneclient/tests

%files
%doc LICENSE README.rst
%_bindir/keystone
%_sysconfdir/bash_completion.d/keystone.bash_completion
%python_sitelibdir/*

%if_with python3
%files -n python3-module-keystoneclient
%_bindir/python3-keystone
%python3_sitelibdir/*
%endif

%files doc
%doc LICENSE doc/build/html

%changelog
