Name: python-module-kivy
Version: 1.9.1
Release: alt1
Summary: Open source library for rapid development of applications
License: LGPLv3
Group: Development/Python
Url: http://kivy.org
Source: %version.tar.gz

%setup_python_module kivy
%add_python_req_skip AppKit
%add_python_req_skip freenect
%add_python_req_skip jnius
%add_python_req_skip android
# recommended
%add_python_req_skip ffpyplayer
%add_python_req_skip pyobjus
# Kivy's internal submodule (relative import is needed?)
%add_python_req_skip doc

# Automatically added by buildreq on Wed Jan 29 2014
# optimized out: libEGL-devel python-base python-devel python-module-BeautifulSoup python-module-Pygments python-module-docutils python-module-html5lib python-module-jinja2 python-module-markupsafe python-module-numpy python-module-numpy-testing python-module-protobuf python-module-setuptools python-module-simplejson python-module-six python-modules python-modules-compiler python-modules-ctypes python-modules-email python-modules-encodings python-modules-logging python-modules-multiprocessing python-modules-unittest
BuildRequires: ctags libGL-devel libGLES-devel python-module-Cython python-module-Pyrex python-module-jinja2-tests python-module-nss python-module-pygame python-module-pytz python-module-sphinx python-modules-json time
BuildRequires: xvfb-run

%description
Kivy - Open source library for rapid development of applications
that make use of innovative user interfaces, such as multi-touch apps.

%package devel
Group: Development/Python
Summary: Development environment for Kivy, %summary
BuildArch: noarch

# TODO garden modules/installer

%description devel
Example files, documentation and packaging tool for Kivy, %summary

%prep
%setup -n Kivy-%version
rm -rf kivy/tools/packaging/osx

for f in `grep -rl '#!/usr/bin/kivy' examples`; do
	sed -i 's|#!/usr/bin/kivy|#!/usr/bin/env python|' $f
done

# XXX Python3
sed -i 's/from xmlrpc.client/from xmlrpclib/' kivy/tools/report.py
sed -i 's/from configparser/from ConfigParser/' kivy/config.py
sed -i 's/from configparser/from ConfigParser/' kivy/tools/pep8checker/pep8.py
sed -i 's/from configparser/from ConfigParser/' kivy/tools/report.py

# XXX
sleep 2
find . -name \*.pyx | xargs touch

%build
%add_optflags -fno-strict-aliasing
%python_build

# XXX
ln doc/sources/.static/logo-kivy.png doc/sources/logo-kivy.png

cd doc &&
  export PYTHONPATH=`ls -d ../build/lib*` &&
  python autobuild.py &&
  export PYTHONPATH=$PYTHONPATH:../kivy/tools/highlight/pygments &&
  xvfb-run make html

%install
%python_install

%files
%doc doc/README.md
%python_sitelibdir/kivy
%python_sitelibdir/Kivy*

%files devel
%doc doc/build/html
%_datadir/kivy-examples
## XXX garden binary is moved to separate module

%changelog
