%def_enable check
%def_with python3

%define oname logilab-common
Name: python-module-%oname
Version: 1.0.2
Release: alt1.hg20150708.1.1

Summary: Useful miscellaneous modules used by Logilab projects
License: LGPLv2.1+
Group: Development/Python

BuildArch: noarch

Url: http://www.logilab.org/project/logilab-common
# hg clone http://hg.logilab.org/review/logilab/common/
Source: %name-%version.tar

Packager: Eugeny A. Rostovtsev (REAL) <real at altlinux.org>

%py_requires mx.DateTime
%add_python_req_skip mercurial sphinx

%setup_python_module %oname

%{?!_without_check:%{?!_disable_check:BuildRequires: /proc %py_dependencies mx.DateTime unittest2}}
#BuildPreReq: python-module-six python-module-pytz
%if_with python3
BuildRequires(pre): rpm-build-python3
# Automatically added by buildreq on Thu Jan 28 2016 (-bi)
# optimized out: python-base python-devel python-module-setuptools python-module-six python-modules python-modules-compiler python-modules-ctypes python-modules-email python-modules-encodings python-modules-logging python-modules-unittest python-modules-xml python-tools-2to3 python3 python3-base xz
BuildRequires: python-module-egenix-mx-base python-module-pytz python-module-unittest2 python3-module-pytz python3-module-setuptools python3-module-six rpm-build-python3 time

#BuildRequires: python3-devel python3-module-distribute
#BuildPreReq: python-tools-2to3
#BuildPreReq: python3-module-six python3-module-pytz
%endif

%description
logilab-common is a collection of low-level Python packages and modules,
designed to ease:
  * handling command line options and configuration files
  * writing interactive command line tools
  * manipulation files and character strings
  * interfacing to OmniORB (removed by packager)
  * generating of SQL queries
  * running unit tests
  * manipulating tree structures
  * accessing RDBMS (currently postgreSQL, mysql and sqlite)
  * generating text and HTML reports
  * logging

%if_with python3
%package -n python3-module-%oname
Summary: Useful miscellaneous modules used by Logilab projects (Python 3)
Group: Development/Python3
%add_python3_req_skip kerberos mercurial sphinx

%description -n python3-module-%oname
logilab-common is a collection of low-level Python packages and modules,
designed to ease:
  * handling command line options and configuration files
  * writing interactive command line tools
  * manipulation files and character strings
  * interfacing to OmniORB (removed by packager)
  * generating of SQL queries
  * running unit tests
  * manipulating tree structures
  * accessing RDBMS (currently postgreSQL, mysql and sqlite)
  * generating text and HTML reports
  * logging
%endif

%prep
%setup
%if_with python3
rm -rf ../python3
cp -a . ../python3
%endif

%build
%python_build
%if_with python3
pushd ../python3
cp setup.py setup.py.back
find -type f -name '*.py' -exec sed -i 's|unittest2|unittest|g' -- '{}' +
find -type f -name '*.py' -exec 2to3 -w -n '{}' +
mv -f setup.py.back setup.py
%python3_build
popd
%endif

%install
%if_with python3
pushd ../python3
%python3_install
install -p -m644 logilab/__init__.py \
	%buildroot%python3_sitelibdir/logilab/
popd
rm -rf %buildroot%python3_sitelibdir/logilab/common/test
mv %buildroot%_bindir/pytest %buildroot%_bindir/pytest3
%endif

%python_install
install -p -m644 logilab/__init__.py \
	%buildroot%python_sitelibdir/logilab/
install -pD -m644 doc/pytest.1 %buildroot%_man1dir/pytest.1
rm -rf %buildroot%python_sitelibdir/logilab/common/test

%check
PYTHONPATH=%buildroot%python_sitelibdir \
    %buildroot%_bindir/pytest \
    -t test \
    -s test_4
%if_with python3
pushd ../python3
PYTHONPATH=%buildroot%python3_sitelibdir \
    %buildroot%_bindir/pytest3 \
    -t test \
    -s test_4
popd
%endif

%files
%_bindir/pytest
%python_sitelibdir/logilab/
%python_sitelibdir/*.egg-info
%_man1dir/*
%doc ChangeLog README

%if_with python3
%files -n python3-module-%oname
%doc ChangeLog README
%_bindir/pytest3
%python3_sitelibdir/logilab/
%python3_sitelibdir/*.egg-info
%endif

%changelog
