%define oname meshpy

%def_with python3

Name: python-module-%oname
Version: 2014.1
Release: alt3.git20140706.1
Summary: Triangular and Tetrahedral Mesh Generator in Python
License: MIT
Group: Development/Python
Url: http://mathema.tician.de/software/meshpy
Packager: Python Development Team <python@packages.altlinux.org>

# http://git.tiker.net/trees/meshpy.git
Source: %oname-%version.tar
# git://github.com/inducer/bpl-subset
Source1: bpl-subset.tar

#BuildPreReq: boost-python-devel gcc-c++ python-module-setuptools
#BuildPreReq: libnumpy-devel python-module-epydoc
#BuildPreReq: doxygen graphviz
%if_with python3
BuildRequires(pre): rpm-build-python3
#BuildPreReq: boost-python3-devel python3-module-setuptools
#BuildPreReq: libnumpy-py3-devel
%endif

# Automatically added by buildreq on Thu Jan 28 2016 (-bi)
# optimized out: elfutils libboost_python3-1.58.0 libstdc++-devel python-base python-devel python-module-PyStemmer python-module-Pygments python-module-babel python-module-cssselect python-module-docutils python-module-genshi python-module-jinja2 python-module-numpy python-module-pyparsing python-module-pytz python-module-snowballstemmer python-module-sphinx python-modules python-modules-compiler python-modules-ctypes python-modules-email python-modules-encodings python-modules-logging python-modules-unittest python3 python3-base python3-dev python3-module-numpy
BuildRequires: boost-python-devel boost-python3-devel gcc-c++ python-module-epydoc python-module-html5lib python-module-matplotlib python-module-numpy-testing python-module-setuptools python3-module-setuptools rpm-build-python3 time

%description
MeshPy offers quality triangular and tetrahedral mesh generation for
Python. Meshes of this type are chiefly used in finite-element
simulation codes, but also have many other applications ranging from
computer graphics to robotics.

%package -n python3-module-%oname
Summary: Triangular and Tetrahedral Mesh Generator in Python
Group: Development/Python3

%description -n python3-module-%oname
MeshPy offers quality triangular and tetrahedral mesh generation for
Python. Meshes of this type are chiefly used in finite-element
simulation codes, but also have many other applications ranging from
computer graphics to robotics.

%package -n python3-module-%oname-tests
Summary: Tests for MeshPy
Group: Development/Python3
Requires: python3-module-%oname = %version-%release

%description -n python3-module-%oname-tests
MeshPy offers quality triangular and tetrahedral mesh generation for
Python. Meshes of this type are chiefly used in finite-element
simulation codes, but also have many other applications ranging from
computer graphics to robotics.

This package contains tests for MeshPy.

%package tests
Summary: Tests for MeshPy
Group: Development/Python
Requires: %name = %version-%release

%description tests
MeshPy offers quality triangular and tetrahedral mesh generation for
Python. Meshes of this type are chiefly used in finite-element
simulation codes, but also have many other applications ranging from
computer graphics to robotics.

This package contains tests for MeshPy.

%package docs
Summary: Documentation for MeshPy
Group: Development/Documentation
BuildArch: noarch

%description docs
MeshPy offers quality triangular and tetrahedral mesh generation for
Python. Meshes of this type are chiefly used in finite-element
simulation codes, but also have many other applications ranging from
computer graphics to robotics.

This package contains documentation for MeshPy.

%prep
%setup

rm -fR bpl-subset
tar -xf %SOURCE1

%if_with python3
rm -rf ../python3
cp -fR . ../python3
sed -i 's|boost_python|boost_python3|' ../python3/setup.py
%endif

%build
./configure.py
%python_build_debug

%if_with python3
pushd ../python3
./configure.py
%python3_build_debug
popd
%endif

export PYTHONPATH=$PWD
%make doc

%install
%python_install

touch test/__init__.py
rm -f test/clean.sh
cp -fR test %buildroot%python_sitelibdir/%oname/

%if_with python3
pushd ../python3
%python3_install
touch test/__init__.py
rm -f test/clean.sh
cp -fR test %buildroot%python3_sitelibdir/%oname/
popd
%endif

%files
%doc LICENSE README
%python_sitelibdir/*
%exclude %python_sitelibdir/%oname/test

%files tests
%python_sitelibdir/%oname/test

%files docs
%doc doc/html/*

%if_with python3
%files -n python3-module-%oname
%doc LICENSE README
%python3_sitelibdir/*
%exclude %python3_sitelibdir/%oname/test

%files -n python3-module-%oname-tests
%python3_sitelibdir/%oname/test
%endif

%changelog
