%define oname mozilla-sphinx-theme

%def_with python3

Name: python-module-%oname
Version: 0.2
Release: alt1.git20130808.1
Summary: A sandstone mozilla theme for sphinx
License: BSD
Group: Development/Python
Url: https://github.com/ametaireau/mozilla-sphinx-theme
Packager: Eugeny A. Rostovtsev (REAL) <real at altlinux.org>

# https://github.com/ametaireau/mozilla-sphinx-theme.git
Source: %name-%version.tar
BuildArch: noarch

BuildPreReq: python-devel python-module-setuptools-tests
BuildPreReq: python-module-sphinx
%if_with python3
BuildRequires(pre): rpm-build-python3
BuildPreReq: python3-devel python3-module-setuptools-tests
BuildPreReq: python3-module-sphinx
%endif

%py_provides mozilla_sphinx_theme

%description
This is a version of Mozilla's sandstone theme, for the Sphinx
documentation engine.

%package -n python3-module-%oname
Summary: A sandstone mozilla theme for sphinx
Group: Development/Python3
%py3_provides mozilla_sphinx_theme

%description -n python3-module-%oname
This is a version of Mozilla's sandstone theme, for the Sphinx
documentation engine.

%prep
%setup

%if_with python3
cp -fR . ../python3
%endif

%build
%python_build_debug

%if_with python3
pushd ../python3
%python3_build_debug
popd
%endif

%install
%python_install

%if_with python3
pushd ../python3
%python3_install
popd
%endif

%check
python setup.py test
%if_with python3
pushd ../python3
python3 setup.py test
popd
%endif

%files
%doc *.rst
%python_sitelibdir/*

%if_with python3
%files -n python3-module-%oname
%doc *.rst
%python3_sitelibdir/*
%endif

%changelog
