%define oname nelsnmp

%def_with python3

Name: python-module-%oname
Version: 0.1.4
Release: alt1.git20150315.1
Summary: A wrapper module for pysnmp
License: ASLv2.0
Group: Development/Python
Url: https://pypi.python.org/pypi/nelsnmp/
Packager: Eugeny A. Rostovtsev (REAL) <real at altlinux.org>

# https://github.com/networklore/nelsnmp.git
Source: %name-%version.tar
BuildArch: noarch

BuildPreReq: python-devel python-module-setuptools-tests
BuildPreReq: python-module-pysnmp4
%if_with python3
BuildRequires(pre): rpm-build-python3
BuildPreReq: python3-devel python3-module-setuptools-tests
BuildPreReq: python3-module-pysnmp4
BuildPreReq: python-tools-2to3
%endif

%py_provides %oname
Requires: python-module-pysnmp4

%description
A wrapper module for pysnmp.

%if_with python3
%package -n python3-module-%oname
Summary: A wrapper module for pysnmp
Group: Development/Python3
%py3_provides %oname
Requires: python3-module-pysnmp4

%description -n python3-module-%oname
A wrapper module for pysnmp.
%endif

%prep
%setup

%if_with python3
cp -fR . ../python3
find ../python3 -type f -name '*.py' -exec 2to3 -w -n '{}' +
%endif

%build
%python_build_debug

%if_with python3
pushd ../python3
%python3_build_debug
popd
%endif

%install
%python_install

%if_with python3
pushd ../python3
%python3_install
popd
%endif

%check
python setup.py test
%if_with python3
pushd ../python3
python3 setup.py test
popd
%endif

%files
%doc CREDITS *.md
%python_sitelibdir/*

%if_with python3
%files -n python3-module-%oname
%doc CREDITS *.md
%python3_sitelibdir/*
%endif

%changelog
