%define oname networkx

%def_enable docs
%def_with python3

Name:           python-module-%oname
Version:        1.10
Release:        alt2.1.1
Epoch:          1
Summary:        Creates and Manipulates Graphs and Networks
Group:          Development/Python
License:        LGPLv2+
URL:            https://networkx.lanl.gov/trac
# https://github.com/networkx/networkx.git
Source:         %oname-%version.tar
Packager: Eugeny A. Rostovtsev (REAL) <real at altlinux.org>

BuildArch:      noarch

BuildRequires(pre): rpm-macros-sphinx
# Automatically added by buildreq on Thu Jan 28 2016 (-bi)
# optimized out: fontconfig fonts-bitmap-misc graphviz ipython libwayland-client libwayland-server python-base python-devel python-module-Pillow python-module-PyStemmer python-module-Pygments python-module-babel python-module-cffi python-module-chardet python-module-cryptography python-module-cssselect python-module-cycler python-module-dateutil python-module-decorator python-module-docutils python-module-enum34 python-module-functools32 python-module-future python-module-genshi python-module-greenlet python-module-ipykernel python-module-ipython_genutils python-module-jinja2 python-module-jinja2-tests python-module-jsonschema python-module-jupyter_client python-module-jupyter_core python-module-markupsafe python-module-matplotlib python-module-mpmath python-module-nbconvert python-module-nbformat python-module-ndg-httpsclient python-module-notebook python-module-ntlm python-module-numpy python-module-path python-module-pexpect python-module-pickleshare python-module-ptyprocess python-module-pyasn1 python-module-pycares python-module-pycurl python-module-pygobject3 python-module-pyparsing python-module-pytz python-module-setuptools python-module-simplegeneric python-module-six python-module-snowballstemmer python-module-sphinx python-module-sphinx_rtd_theme python-module-terminado python-module-tornado_xstatic python-module-traitlets python-module-wx3.0 python-module-xstatic python-module-xstatic-term.js python-module-zmq python-module-zope.interface python-modules python-modules-compiler python-modules-ctypes python-modules-email python-modules-encodings python-modules-json python-modules-logging python-modules-multiprocessing python-modules-sqlite3 python-modules-unittest python-modules-wsgiref python-modules-xml python-tools-2to3 python3 python3-base
BuildRequires: python-module-alabaster python-module-html5lib python-module-ipyparallel python-module-numpy-testing python-module-objects.inv python-module-pydot python-module-pygraphviz python-module-scipy python-module-sphinx-pickles python-module-yaml python3-module-setuptools rpm-build-python3 time

#BuildRequires: python-devel
#BuildPreReq: python-module-pygraphviz ipython libnumpy-devel
#BuildPreReq: python-module-pydot python-module-matplotlib
#BuildPreReq: python-module-yaml python-module-scipy python-module-pyparsing
#BuildPreReq: python-module-sphinx-devel python-module-Pygments
#BuildPreReq: graphviz python-module-setuptools python-module-decorator
#BuildPreReq: python-module-sphinx_rtd_theme
%if_with python3
BuildRequires(pre): rpm-build-python3
#BuildRequires: python3-devel python-tools-2to3 python3-module-setuptools
%endif

Requires: %name-drawing = %EVR

%description
NetworkX is a Python package for the creation, manipulation, and
study of the structure, dynamics, and functions of complex networks.

%package core
Summary: Creates and Manipulates Graphs and Networks
Group: Development/Python
Requires: python-module-decorator
Requires: python-module-yaml
Requires: python-module-numpy
Requires: python-module-scipy
%add_python_req_skip tests
%add_python_req_skip networkx.drawing
%add_python_req_skip networkx.tests.test

%description core
NetworkX is a Python package for the creation, manipulation, and
study of the structure, dynamics, and functions of complex networks.

%package drawing
Summary: Creates and Manipulates Graphs and Networks
Group: Development/Python
Requires: %name-core = %EVR
Requires: python-module-pygraphviz
Requires: python-module-pydot
Requires: python-module-matplotlib

%description drawing
NetworkX is a Python package for the creation, manipulation, and
study of the structure, dynamics, and functions of complex networks.

This package provides support for graph visualizations.

%if_with python3
%package -n python3-module-%oname-core
Summary: Creates and Manipulates Graphs and Networks (Python 3)
Group: Development/Python3
Requires: python3-module-decorator
Requires: python3-module-yaml
Requires: python3-module-numpy
Requires: python3-module-scipy
%add_python3_req_skip tests

%description -n python3-module-%oname-core
NetworkX is a Python package for the creation, manipulation, and
study of the structure, dynamics, and functions of complex networks.

%package -n python3-module-%oname-drawing
Summary: Creates and Manipulates Graphs and Networks (Python 3)
Group: Development/Python3
Requires: python3-module-%oname-core = %EVR
Requires: python3-module-pygraphviz
Requires: python3-module-pydot
Requires: python3-module-matplotlib

%description -n python3-module-%oname-drawing
NetworkX is a Python package for the creation, manipulation, and
study of the structure, dynamics, and functions of complex networks.

This package provides support for graph visualizations.

%package -n python3-module-%oname
Summary: Creates and Manipulates Graphs and Networks (Python 3)
Group: Development/Python3
Requires: python3-module-%oname-drawing = %EVR

%description -n python3-module-%oname
NetworkX is a Python package for the creation, manipulation, and
study of the structure, dynamics, and functions of complex networks.

%package -n python3-module-%oname-tests
Summary: Tests for NetworkX (Python 3)
Group: Development/Python3
Requires: python3-module-%oname = %EVR

%description -n python3-module-%oname-tests
NetworkX is a Python package for the creation, manipulation, and
study of the structure, dynamics, and functions of complex networks.

This package contains tests for NetworkX.
%endif

%if_enabled docs

%package docs
Summary: Documentation for NetworkX
Group: Development/Documentation

%description docs
NetworkX is a Python package for the creation, manipulation, and
study of the structure, dynamics, and functions of complex networks.

This package contains development documentation for NetworkX.

%package pickles
Summary: Pickles for NetworkX
Group: Development/Python

%description pickles
NetworkX is a Python package for the creation, manipulation, and
study of the structure, dynamics, and functions of complex networks.

This package contains pickles for NetworkX.

%endif

%package tests
Summary: Tests for NetworkX
Group: Development/Python
Requires: %name = %EVR

%description tests
NetworkX is a Python package for the creation, manipulation, and
study of the structure, dynamics, and functions of complex networks.

This package contains tests for NetworkX.

%prep
%setup
chmod -x examples/*/*.py
chmod -x examples/*/*.bz2
sed -i '1,1d' networkx/tests/test.py

%if_with python3
rm -rf ../python3
cp -a . ../python3
%endif

%if_enabled docs
sed -i 's|@PYVER@|%_python_version|g' doc/Makefile
%prepare_sphinx .
%endif

%build
#python_build_debug
#pushd nose_plugin
%python_build
#popd

%if_with python3
pushd ../python3
#find -type f -name '*.py' -exec 2to3 -w -n '{}' +
find -type f -name '*.py' -exec sed -i \
	's|#!/usr/bin/env python|#!/usr/bin/env python3|' '{}' +
#python3_build_debug
%python3_build
popd
%endif

%install
%python_install -O1
#pushd nose_plugin
#python_install -O1
#popd

%if_with python3
pushd ../python3
%python3_install
popd
%endif

%if_enabled docs
export PYTHONPATH=$PYTHONPATH:%buildroot%python_sitelibdir
#make -C doc latex ||:
#cp doc/build/doctrees/reference/credits.doctree \
#	doc/build/doctrees/
%make -C doc html

mkdir installed-docs
mv %buildroot%_docdir/%oname-%{version}* ./installed-docs

cp -fR doc/build/pickle %buildroot%python_sitelibdir/%oname/
%endif

%files
%files core
%python_sitelibdir/*
#exclude %python_sitelibdir/networkxdoctest.py*
%if_enabled docs
%exclude %python_sitelibdir/%oname/pickle
%endif
%exclude %python_sitelibdir/%oname/drawing
%exclude %python_sitelibdir/%oname/readwrite/nx_shp.py*
%exclude %python_sitelibdir/*/tests
%exclude %python_sitelibdir/*/testing
%exclude %python_sitelibdir/*/*/tests
%exclude %python_sitelibdir/*/*/*/tests

%files drawing
%python_sitelibdir/%oname/drawing
%python_sitelibdir/%oname/readwrite/nx_shp.py*
%exclude %python_sitelibdir/%oname/drawing/tests

%files tests
#python_sitelibdir/networkxdoctest.py*
%python_sitelibdir/*/tests
%python_sitelibdir/*/testing
%python_sitelibdir/*/*/tests
%python_sitelibdir/*/*/*/tests

%if_enabled docs

%files docs
%doc installed-docs/*
%doc doc/build/html

%files pickles
%python_sitelibdir/%oname/pickle

%endif

%if_with python3
%files -n python3-module-%oname

%files -n python3-module-%oname-core
%python3_sitelibdir/*
%exclude %python3_sitelibdir/%oname/drawing
%exclude %python3_sitelibdir/%oname/readwrite/nx_shp.py*
%exclude %python3_sitelibdir/*/tests
%exclude %python3_sitelibdir/*/testing
%exclude %python3_sitelibdir/*/*/tests
%exclude  %python3_sitelibdir/*/*/*/tests

%files -n python3-module-%oname-drawing
%python3_sitelibdir/%oname/drawing
%python3_sitelibdir/%oname/readwrite/nx_shp.py*
%exclude %python3_sitelibdir/%oname/drawing/tests

%files -n python3-module-%oname-tests
%python3_sitelibdir/*/tests
%python3_sitelibdir/*/testing
%python3_sitelibdir/*/*/tests
%python3_sitelibdir/*/*/*/tests
%endif

%changelog
