%def_with python3

Name: python-module-novaclient
Version: 3.3.2
Release: alt0.M80P.1
Summary: Python API and CLI for OpenStack Nova

Group: Development/Python
License: ASL 2.0
Url: http://pypi.python.org/pypi/python-novaclient
Source: %name-%version.tar

BuildArch: noarch

Requires: python-module-simplejson
Requires: python-module-keystoneclient
#Requires: python-module-keyring

BuildRequires: python-devel
BuildRequires: python-module-d2to1
BuildRequires: python-module-setuptools
BuildRequires: python-module-pbr >= 1.6
BuildRequires: python-module-sphinx
BuildRequires: python-module-oslosphinx
BuildRequires: python-module-keystoneauth1 >= 2.1.0
BuildRequires: python-module-iso8601 >= 0.1.9
BuildRequires: python-module-oslo.i18n >= 2.1.0
BuildRequires: python-module-oslo.serialization >= 1.10.0
BuildRequires: python-module-oslo.utils >= 3.5.0
BuildRequires: python-module-prettytable >= 0.7
BuildRequires: python-module-requests >= 2.8.1
BuildRequires: python-module-simplejson >= 2.2.0
BuildRequires: python-module-six >= 1.9.0
BuildRequires: python-module-babel >= 1.3

%if_with python3
BuildRequires(pre): rpm-build-python3
BuildRequires: python3-devel
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-pbr >= 1.6
BuildRequires: python3-module-keystoneauth1 >= 2.1.0
BuildRequires: python3-module-babel >= 1.3
BuildRequires: python3-module-six >= 1.9.0
BuildRequires: python3-module-iso8601 >= 0.1.9
BuildRequires: python3-module-prettytable >= 0.7
BuildRequires: python3-module-requests >= 2.8.1
BuildRequires: python3-module-oslo.i18n >= 2.1.0
BuildRequires: python3-module-oslo.utils >= 3.5.0
BuildRequires: python3-module-oslo.serialization >= 1.10.0
BuildRequires: python3-module-simplejson >= 2.2.0
%endif

%description
This is a client for the OpenStack Nova API. There's a Python API (the
novaclient module), and a command-line script (nova). Each implements 100 percent of
the OpenStack Nova API.

%if_with python3
%package -n python3-module-novaclient
Summary: Python API and CLI for OpenStack Nova
Group: Development/Python3
Requires: python3-module-simplejson
Requires: python3-module-keystoneclient
#Requires: python3-module-keyring

%description -n python3-module-novaclient
This is a client for the OpenStack Nova API. There's a Python API (the
novaclient module), and a command-line script (nova). Each implements 100 percent of
the OpenStack Nova API.
%endif


%package doc
Summary: Documentation for OpenStack Nova API Client
Group: Development/Documentation

%description doc
This is a client for the OpenStack Nova API. There's a Python API (the
novaclient module), and a command-line script (nova). Each implements 100 percent of
the OpenStack Nova API.

This package contains auto-generated documentation.

%prep
%setup

# Remove bundled egg-info
rm -rf python_novaclient.egg-info

# Let RPM handle the requirements
rm -f {,test-}requirements.txt

%if_with python3
rm -rf ../python3
cp -a . ../python3
%endif

%build
%python_build
%if_with python3
pushd ../python3
%python3_build
popd
%endif

# disabling git call for last modification date from git repo
sed '/^html_last_updated_fmt.*/,/.)/ s/^/#/' -i doc/source/conf.py
python setup.py build_sphinx
# Fix hidden-file-or-dir warnings
rm -fr doc/build/html/.buildinfo

%install
%if_with python3
pushd ../python3
%python3_install
popd
mv %buildroot%_bindir/nova %buildroot%_bindir/python3-nova
%endif

%python_install

mkdir -p %buildroot%_sysconfdir/bash_completion.d
install -pm 644 tools/nova.bash_completion \
    %buildroot%_sysconfdir/bash_completion.d/nova

# Delete tests
rm -fr %buildroot%python_sitelibdir/tests
rm -fr %buildroot%python_sitelibdir/*/tests
rm -fr %buildroot%python3_sitelibdir/tests
rm -fr %buildroot%python3_sitelibdir/*/tests

install -p -D -m 644 doc/build/man/nova.1 %buildroot%_man1dir/nova.1

%files
%doc README.rst
%doc LICENSE
%_bindir/nova
%python_sitelibdir/*
%_sysconfdir/bash_completion.d
%_man1dir/nova.*

%if_with python3
%files -n python3-module-novaclient
%_bindir/python3-nova
%python3_sitelibdir/*
%endif

%files doc
%doc doc/build/html

%changelog
