%define oname openpyxl
%def_with python3

Name:    python-module-%oname
Version: 2.3.5
Release: alt1
Summary: A Python library to read/write Excel 2007 xlsx/xlsm files
License: MIT/Expat
Group:   Development/Python
Url:     http://openpyxl.readthedocs.io
Packager: Andrey Cherepanov <cas@altlinux.org>

Source: %oname-%version.tar

BuildArch: noarch

%py_requires jdcal json et_xmlfile

BuildRequires: python-module-jdcal
BuildRequires: python-module-setuptools-tests
BuildRequires: python-modules-json
BuildRequires: python-module-memory_profiler

%if_with python3
BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-jdcal
BuildRequires: python3-module-setuptools-tests
BuildRequires: python3-module-memory_profiler
%endif

%py_provides %oname

%description
openpyxl is a Python library to read/write Excel 2010 xlsx/xlsm files.

It was born from lack of existing library to read/write natively from
Python the Office Open XML format.

%package -n python3-module-%oname
Summary: A Python library to read/write Excel 2007 xlsx/xlsm files
Group: Development/Python3
%py3_provides %oname
%py3_requires jdcal et_xmlfile

%description -n python3-module-%oname
openpyxl is a Python library to read/write Excel 2010 xlsx/xlsm files.

It was born from lack of existing library to read/write natively from
Python the Office Open XML format.

%prep
%setup -q -n %oname-%version

%if_with python3
cp -fR . ../python3
%endif

%build
%python_build

%if_with python3
pushd ../python3
%python3_build
popd
%endif

%install
%python_install

%if_with python3
pushd ../python3
%python3_install
popd
%endif

%check
python setup.py test
%if_with python3
pushd ../python3
python3 setup.py test
popd
%endif

%files
%doc *.rst
%python_sitelibdir/*

%if_with python3
%files -n python3-module-%oname
%doc *.rst
%python3_sitelibdir/*
%endif

%changelog
