%define	version	1.16.0
%define release alt2
%define source_version %version
%define source_name  paramiko
%setup_python_module paramiko

%def_with python3

Summary: SSH2 protocol for python
Packager: Andriy Stepanov <stanv@altlinux.ru>
Name: python-module-paramiko
Version: %version
Release: alt2.1.1.1
Source: %name-%version.tar
Patch: %name-%version-%release.patch

License: GPL
Group: Development/Python
Url: http://www.lag.net/paramiko
BuildArch: noarch

#BuildPreReq: python-module-setuptools-tests
#BuildPreReq: python-module-ecdsa python-module-pycrypto
%if_with python3
BuildRequires(pre): rpm-build-python3
#BuildPreReq: python3-devel python3-module-setuptools-tests
#BuildPreReq: python3-module-ecdsa python3-module-pycrypto
#BuildPreReq: python-tools-2to3
%endif

# Automatically added by buildreq on Fri Jan 29 2016 (-bi)
# optimized out: python-base python-devel python-module-pytest python-module-setuptools python-modules python-modules-compiler python-modules-ctypes python-modules-email python-modules-encodings python-modules-unittest python3 python3-base python3-module-pytest python3-module-setuptools
BuildRequires: python-module-ecdsa python-module-pycrypto python-module-setuptools-tests python3-module-ecdsa python3-module-pycrypto python3-module-setuptools-tests rpm-build-python3

%description
paramiko is a module for python that implements the SSH2 protocol for secure
(encrypted and authenticated) connections to remote machines. It is written
entirely in python (no C or platform-dependent code).

This module is built for python %_python_version.

%package -n python3-module-%source_name
Summary: SSH2 protocol for python
Group: Development/Python3

%description -n python3-module-%source_name
paramiko is a module for python that implements the SSH2 protocol for secure
(encrypted and authenticated) connections to remote machines. It is written
entirely in python (no C or platform-dependent code).

This module is built for python %_python3_version.

%package doc
Summary: %modulename documentation and example programs
Group: Development/Python
Prefix: %_prefix
Requires: python-module-%modulename = %version
%description doc
%modulename paramiko is a module for python that implements the SSH2 protocol
for secure (encrypted and authenticated) connections to remote machines. This
package contain API documentation and examples for python-%modulename module.

%prep
%setup
%patch -p1

%if_with python3
cp -fR . ../python3
#find ../python3 -type f -name '*.py' -exec 2to3 -w -n '{}' +
%endif

%build
%python_build

%if_with python3
pushd ../python3
%python3_build
popd
%endif

%install
%python_install --install-lib %python_sitelibdir

%if_with python3
pushd ../python3
%python3_install --install-lib %python3_sitelibdir
popd
%endif

%check
python setup.py test
%if_with python3
pushd ../python3
python3 setup.py test
popd
%endif

%files
%python_sitelibdir/%source_name
%python_sitelibdir/*.egg-info
%doc README LICENSE

%files doc
%doc demos

%if_with python3
%files -n python3-module-%source_name
%python3_sitelibdir/%source_name
%python3_sitelibdir/*.egg-info
%doc README LICENSE
%endif

%changelog
