%define oname pexpect

%def_with python3
%def_disable check

Name: python-module-%oname
Version: 4.0
Release: alt1.dev.git20150811.1

%setup_python_module %oname

Summary: Pexpect is a pure Python Expect. It allows easy control of other applications

License: Python Software Foundation License
Group: Development/Python
Url: http://pexpect.sourceforge.net/

# https://github.com/pexpect/pexpect.git
Source: %name-%version.tar

BuildArch: noarch

Obsoletes: %oname < 0.999-alt6
Provides: %oname

%add_findreq_skiplist %python_sitelibdir/%oname/async.py

BuildPreReq: python-devel python-module-setuptools-tests /dev/pts
BuildPreReq: python-module-pytest-cov python-module-ptyprocess
%if_with python3
BuildRequires(pre): rpm-build-python3
BuildPreReq: python3-devel python3-module-setuptools-tests
BuildPreReq: python3-module-pytest-cov python3-module-ptyprocess
%endif

BuildPreReq: python-module-sphinx-devel

%description
Pexpect is a pure Python module for spawning child applications; controlling
them; and responding to expected patterns in their output. Pexpect works like
Don Libes' Expect. Pexpect allows your script to spawn a child application and
control it as if a human were typing commands.

%package -n python3-module-%oname
Summary: Pexpect is a pure Python Expect. It allows easy control of other applications
Group: Development/Python3

%description -n python3-module-%oname
Pexpect is a pure Python module for spawning child applications; controlling
them; and responding to expected patterns in their output. Pexpect works like
Don Libes' Expect. Pexpect allows your script to spawn a child application and
control it as if a human were typing commands.

%package pickles
Summary: Pickles for Pexpect
Group: Development/Python

%description pickles
Pexpect is a pure Python module for spawning child applications; controlling
them; and responding to expected patterns in their output. Pexpect works like
Don Libes' Expect. Pexpect allows your script to spawn a child application and
control it as if a human were typing commands.

This package contains pickles for Pexpect.

%prep
%setup

%if_with python3
cp -fR . ../python3
%endif

%prepare_sphinx .
ln -s ../objects.inv doc/

%build
%python_build

%if_with python3
pushd ../python3
%python3_build
popd
%endif

%install
%python_install

%if_with python3
pushd ../python3
%python3_install
popd
%endif

export PYTHONPATH=%buildroot%python_sitelibdir
%make -C doc pickle
%make -C doc html

cp -fR doc/_build/pickle %buildroot%python_sitelibdir/%oname/

%check
py.test -vv --cov pexpect --cov-config .coveragerc
%if_with python3
pushd ../python3
py.test-%_python3_version -vv --cov pexpect --cov-config .coveragerc
popd
%endif

%files
%doc DEVELOPERS* LICENSE README.rst doc/_build/html examples
%python_sitelibdir/*
%exclude %python_sitelibdir/*/pickle

%files pickles
%python_sitelibdir/*/pickle

%if_with python3
%files -n python3-module-%oname
%doc DEVELOPERS* LICENSE README.rst doc/_build/html examples
%python3_sitelibdir/*
%endif

%changelog
