%define modulename pika

%def_with python3

Name: python-module-%modulename
Version: 0.10.0
Release: alt1

%setup_python_module %modulename

Summary: Pika is a pure-Python implementation of the AMQP 0-9-1 protocol.
License: MPLv2.0
Group: Development/Python

Url: http://github.com/pika/pika
BuildArch: noarch

Source: %name-%version.tar

BuildRequires(pre): rpm-macros-sphinx
BuildRequires: python-devel
BuildRequires: python-module-setuptools
BuildRequires: python-module-sphinx-devel python-module-twisted-core
BuildRequires: python-module-tornado
%if_with python3
BuildRequires(pre): rpm-build-python3
BuildPreReq: python3-devel python3-module-setuptools
%endif

%py_requires twisted.internet tornado

%description
Pika is a pure-Python implementation of the AMQP 0-9-1 protocol that
tries to stay fairly independent of the underlying network support
library.

%package docs
Summary: Documentation for %modulename
Group: Development/Documentation

%description docs
Pika is a pure-Python implementation of the AMQP 0-9-1 protocol that
tries to stay fairly independent of the underlying network support
library.

This package contains documentation for %modulename.

%package -n python3-module-%modulename
Summary: Pika is a pure-Python implementation of the AMQP 0-9-1 protoco
Group: Development/Python3
%py3_requires twisted.internet tornado

%description -n python3-module-%modulename
Pika is a pure-Python implementation of the AMQP 0-9-1 protocol that
tries to stay fairly independent of the underlying network support
library.

%prep
%setup

%if_with python3
cp -fR . ../python3
%endif

%prepare_sphinx .
ln -s ../objects.inv docs/

%build
%python_build

%if_with python3
pushd ../python3
%python3_build
popd
%endif

# generate html docs
python setup.py build_sphinx
# remove the sphinx-build leftovers
rm -rf build/sphinx/html/.{doctrees,buildinfo}

%install
%python_install

%if_with python3
pushd ../python3
%python3_install
popd
%endif

# Delete tests
rm -fr %buildroot%python_sitelibdir/tests
rm -fr %buildroot%python_sitelibdir/*/tests
rm -fr %buildroot%python3_sitelibdir/tests
rm -fr %buildroot%python3_sitelibdir/*/tests


%files
%doc *.rst
%python_sitelibdir/*

%files docs
%doc build/sphinx/html/*

%if_with python3
%files -n python3-module-%modulename
%doc *.rst
%python3_sitelibdir/*
%endif

%changelog
