%define _unpackaged_files_terminate_build 1

%define oname pip

%def_with python3
%def_without doc

Summary: pip installs packages.  Python packages.  An easy_install replacement
Name: python-module-%oname
Version: 10.0.1
Release: alt1%ubt
License: MIT
Group: Development/Python
BuildArch: noarch
Url: http://www.pip-installer.org

# https://github.com/pypa/pip.git
Source: %name-%version.tar

BuildRequires(pre): rpm-build-ubt
BuildRequires: python-module-setuptools

%if_with doc
BuildRequires(pre): rpm-macros-sphinx
BuildRequires: python-module-alabaster python-module-docutils python-module-html5lib python-module-objects.inv
%endif

%if_with python3
BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-setuptools
%add_python3_req_skip  UserDict
%endif

%description
%summary

%if_with doc
%package pickles
Summary: Pickles for pip
Group: Development/Python

%description pickles
%summary

This package contains pickles for pip.

%package docs
Summary: Documentation for pip
Group: Development/Documentation

%description docs
%summary

This package contains documentation for pip.
%endif

%if_with python3
%package -n python3-module-%oname
Summary: pip installs packages.  Python packages.  An easy_install replacement
Group: Development/Python3
%py3_provides %oname pip._vendor.six.moves pip._vendor.six.moves.urllib pip._vendor.six.moves.urllib.parse

%description -n python3-module-%oname
%summary
%endif

%prep
%setup

%if_with python3
cp -a . ../python3
%endif

%if_with doc
%prepare_sphinx .
ln -s ../objects.inv docs/
%endif

%build
%python_build

%if_with python3
pushd ../python3
%python3_build
popd
%endif

%install
%if_with python3
pushd ../python3
%python3_install
popd
%endif

%python_install

%if_with doc
export PYTHONPATH=%buildroot%python_sitelibdir
%make -C docs pickle
%make -C docs html

cp -fR docs/_build/pickle %buildroot%python_sitelibdir/%oname/
%endif

%files
%doc *.txt *.rst
%_bindir/*
%if_with python3
%exclude %_bindir/pip3*
%endif
%python_sitelibdir/*
%if_with doc
%exclude %python_sitelibdir/*/pickle

%files pickles
%python_sitelibdir/*/pickle

%files docs
%doc docs/_build/html/*
%endif

%if_with python3
%files -n python3-module-%oname
%doc *.txt *.rst
%_bindir/pip3*
%python3_sitelibdir/*
%endif

%changelog
