# This spec is backported to ALTLinux p8 automatically by rpmbph script from etersoft-build-utils.
#
%define oname poppler-qt5

%def_with python3

Name: python-module-%oname
Version: 0.24.2
Release: alt0.M80P.1.git20170214.1
Summary: A Python binding to Poppler-Qt5
License: LGPLv2.1+
Group: Development/Python
Url: https://pypi.python.org/pypi/python-poppler-qt5/
Packager: Eugeny A. Rostovtsev (REAL) <real at altlinux.org>

# https://github.com/wbsoft/python-poppler-qt5.git
# tag: v0.24.2
Source: %name-%version.tar

BuildPreReq: gcc-c++ qt5-base-devel libpoppler-qt5-devel
BuildPreReq: python-devel python-module-setuptools-tests
BuildPreReq: python-module-sip-devel python-module-PyQt5-devel
%if_with python3
BuildRequires(pre): rpm-build-python3
BuildPreReq: python3-devel python3-module-setuptools-tests
BuildPreReq: python3-module-sip-devel python3-module-PyQt5-devel
%endif

%description
A Python binding for libpoppler-qt5 that aims for completeness and for
being actively maintained.

%package -n python3-module-%oname
Summary: A Python binding to Poppler-Qt5
Group: Development/Python3

%description -n python3-module-%oname
A Python binding for libpoppler-qt5 that aims for completeness and for
being actively maintained.

%prep
%setup

%if_with python3
cp -fR . ../python3
%endif

%build
export PATH=$PATH:%_qt5_bindir
%python_build_debug

%if_with python3
pushd ../python3
%python3_build_debug --debug -j6
popd
%endif

%install
export PATH=$PATH:%_qt5_bindir
%python_install

%if_with python3
pushd ../python3
%python3_install
popd
%endif

%check
export PATH=$PATH:%_qt5_bindir
python setup.py test
%if_with python3
pushd ../python3
python3 setup.py test
popd
%endif

%files
%doc ChangeLog TODO *.rst demo.py
%python_sitelibdir/*

%if_with python3
%files -n python3-module-%oname
%doc ChangeLog TODO *.rst demo.py
%python3_sitelibdir/*
%endif

%changelog
