%define oname psycopg2
%def_with python3

Version: 2.7
Release: alt1.dev0.git20150602.1.1
%setup_python_module %oname

Summary: psycopg2 is a PostgreSQL database adapter for Python
Name: %packagename
# https://github.com/psycopg/psycopg2.git
Source0: psycopg2.tar
License: GPL
Group: Development/Python
URL: http://www.psycopg.org/psycopg/
# Automatically added by buildreq on Fri Jan 29 2016 (-bi)
# optimized out: elfutils libpq-devel libsasl2-3 python-base python-modules python-modules-compiler python-modules-email python3 python3-base
BuildRequires: postgresql-devel python-devel python3-devel rpm-build-python3

#BuildRequires: postgresql-devel
%if_with python3
BuildRequires(pre): rpm-build-python3
#BuildRequires: python3-devel python-tools-2to3
%endif

Requires: python-modules-json

%description
psycopg is a PostgreSQL database adapter for the Python programming
language (just like pygresql and popy.) It was written from scratch with
the aim of being very small and fast, and stable as a rock. The main
advantages of psycopg are that it supports the full Python DBAPI-2.0 and
being thread safe at level 2.

%if_with python3
%package -n python3-module-%oname
Summary: psycopg2 is a PostgreSQL database adapter for Python 3
Group: Development/Python3

%description -n python3-module-%oname
psycopg is a PostgreSQL database adapter for the Python 3 programming
language (just like pygresql and popy.) It was written from scratch with
the aim of being very small and fast, and stable as a rock. The main
advantages of psycopg are that it supports the full Python DBAPI-2.0 and
being thread safe at level 2.

%package -n python3-module-%oname-tests
Summary: Tests for psycopg2 python 3 PostgreSQL database adapter
Group: Development/Python3
Requires: python3-module-%oname = %version-%release

%description -n python3-module-%oname-tests
Tests for the psycopg2 python 3 PostgreSQL database adapter.
%endif

%package tests
Summary: Tests for psycopg2 python PostgreSQL database adapter
Group: Development/Python
Requires: %name = %version-%release

%description tests
Tests for the psycopg2 python PostgreSQL database adapter.

%package doc
Summary: Documentation for psycopg2 python PostgreSQL database adapter
Group: Development/Python
BuildArch: noarch

%description doc
Documenation and example files for the psycopg2 python PostgreSQL
database adapter.

%prep
%setup

echo "include_dirs=.:/usr/include/pgsql" >> setup.cfg

%build
%add_optflags -fno-strict-aliasing
%python_build
%python3_build

%install
%python_install --optimize=2 --record=INSTALLED_FILES
%python3_install
sed -i 's|_psycopg|%oname._psycopg|' \
	%buildroot%python3_sitelibdir/%oname/psycopg1.py

%files -f INSTALLED_FILES
%dir %python_sitelibdir/psycopg2
%exclude %python_sitelibdir/psycopg2/tests

%files tests
%python_sitelibdir/psycopg2/tests

%files doc
%doc AUTHORS INSTALL README* doc examples

%if_with python3
%files -n python3-module-%oname
%python3_sitelibdir/*
%exclude %python3_sitelibdir/*/tests

%files -n python3-module-%oname-tests
%python3_sitelibdir/*/tests
%endif

%changelog
