%define _name pyatspi
%define ver_major 2.24

Name: python-module-%_name
Version: %ver_major.0
Release: alt0.M80P.1

Summary: Python bindings for at-spi library
Group: Development/Python
License: LGPLv2+
Url: http://www.linuxfoundation.org/en/AT-SPI_on_D-Bus

Source: ftp://ftp.gnome.org/pub/gnome/sources/%_name/%ver_major/%_name-%version.tar.xz

BuildArch: noarch

BuildRequires: python-devel python-module-pygobject3-devel >= 3.9.90
BuildRequires: rpm-build-python3 python3-devel python3-module-pygobject3-devel >= 3.9.90
BuildRequires: libX11-devel libICE-devel libSM-devel

%description
at-spi allows assistive technologies to access GTK-based
applications. Essentially it exposes the internals of applications for
automation, so tools such as screen readers, magnifiers, or even
scripting interfaces can query and interact with GUI controls.

This version of at-spi is a major break from previous versions.
It has been completely rewritten to use D-Bus rather than
ORBIT / CORBA for its transport protocol.

This package includes a python client library for at-spi.

%package -n python3-module-%_name
Summary: Python3 bindings for at-spi
Group: Development/Python3

%description -n python3-module-%_name
at-spi allows assistive technologies to access GTK-based
applications. Essentially it exposes the internals of applications for
automation, so tools such as screen readers, magnifiers, or even
scripting interfaces can query and interact with GUI controls.

This version of at-spi is a major break from previous versions.
It has been completely rewritten to use D-Bus rather than
ORBIT / CORBA for its transport protocol.

This package provides Python3 bindings for at-spi library.

%prep
%setup -n %_name-%version
%setup -D -c -n %_name-%version
mv %_name-%version py3build

%build
export PYTHON=%__python
%configure --with-python=python2
%make_build

pushd py3build
export PYTHON=python3
%autoreconf
%configure --with-python=python3
%make_build
popd

%install
%makeinstall_std

pushd py3build
%makeinstall_std
popd

%files
#%_bindir/magFocusTracker.py
%python_sitelibdir/%_name/
%doc AUTHORS README NEWS

%files -n python3-module-%_name
%python3_sitelibdir/%_name/
%doc AUTHORS README NEWS

%changelog
