%def_enable snapshot
%def_enable numpy
%def_disable docs

%define major 2.24
Name: python-module-pygtk
Version: %major.0
Release: alt6

Summary: Python bindings for the GTK+ widget set

Group: Development/Python
License: LGPL
Url: http://www.pygtk.org/
Packager: GNOME Maintainers Team <gnome@packages.altlinux.org>

%if_enabled snapshot
Source: pygtk-%version.tar
%else
Source: http://ftp.gnome.org/pub/GNOME/sources/pygtk/%major/pygtk-%version.tar.bz2
%endif
Patch: pygtk-2.14.0-alt-configure.patch

%setup_python_module pygtk
%add_python_req_skip gdk

Provides: pygtk2 = %version-%release
Obsoletes: pygtk2

%py_provides argtypes

%define pygobject_ver 2.26.0
%define pycairo_ver 1.4.12
%define gtk_ver 2.22.0
%define glade_ver 2.5.1

# don't reqs automatically
Requires: python-module-pycairo >= %pycairo_ver
%{?_enable_numpy:Requires:python-module-numpy python-module-numpy-addons}

BuildRequires: rpm-build-compat gtk-doc rpm-build-python python-devel gnome-common
BuildRequires: python-module-pygobject-devel >= %pygobject_ver
BuildRequires: python-module-pycairo-devel >= %pycairo_ver
BuildRequires: libgtk+2-devel >= %gtk_ver
BuildRequires: libglade-devel >= %glade_ver
%{?_enable_numpy:BuildRequires: libnumpy-devel}
# style.css from this package required to build documentation
BuildRequires: python-module-pygobject-devel-doc

%description
PyGTK is an extension module for python that gives you access to the GTK+
widget set.  Just about anything you can write in C with GTK+ you can write
in python with PyGTK (within reason), but with all the benefits of python.


%package libglade
Summary: A wrapper for the libglade library for use with PyGTK
Group: Development/Python
Requires: %name = %version-%release
%py_provides libglade

%description libglade
This module contains a wrapper for the libglade library. Libglade allows
a program to construct its user interface from an XML description, which
allows the programmer to keep the UI and program logic separate.

%package devel
Summary: files needed to build wrappers for GTK+ addon libraries
Group: Development/Python
Requires: %name = %version-%release
Requires: python-module-pygobject-devel

%description devel
This package contains files required to build wrappers for GTK+ addon
libraries so that they interoperate with pygtk.

%package examples
Summary: PyGTK examples
Group: Development/Python
BuildArch: noarch
Requires: %name-libglade = %version-%release

%description examples
This package contains PyGTK examples

%package demo
Summary: PyGTK demo
Group: Development/Python
Requires: %name = %version-%release

%description demo
This package contains PyGTK demo

%package doc
Summary: PyGTK doc
Group: Development/Python
BuildArch: noarch

%description doc
This package contains PyGTK doc

%prep
%setup -q -n %modulename-%version
%patch

%__subst "s|@PYTHON@|%_bindir/env python|g" pygtk-codegen-2.0.in examples/pygtk-demo/pygtk-demo.in

%build
#NOCONFIGURE=1 gnome-autogen.sh
%autoreconf -I m4
%configure --disable-static \
	%{subst_enable numpy} \
	%{subst_enable docs} \
	%{?_enable_snapshot:--enable-docs}

%make_build

%install
%makeinstall_std
mkdir -p %buildroot%_includedir/python%__python_version
mv %buildroot%_includedir/pygtk-2.0 %buildroot%_includedir/python%__python_version/pygtk
subst "s|\${includedir}/pygtk-2.0|\${includedir}/python%__python_version/pygtk|g" %buildroot/%_pkgconfigdir/*.pc

# something broken if gobject still here
test -f %buildroot%python_sitelibdir/gtk-2.0/gobject.so && exit 1

%files
%python_sitelibdir/gtk-2.0/*
%exclude %python_sitelibdir/gtk-2.0/gtk/glade.so
%doc AUTHORS NEWS README MAPPING THREADS TODO

%files examples
%doc examples/*

%files demo
%_bindir/pygtk-demo
%_libdir/%modulename/

%files libglade
%python_sitelibdir/gtk-2.0/gtk/glade.so

%files devel
%_bindir/pygtk-codegen-2.0
%python_includedir/pygtk/pygtk/
%_pkgconfigdir/pygtk*.pc
%_datadir/%modulename/

%files doc
%_datadir/gtk-doc/html/pygtk/

%changelog
