%def_enable numpy
%def_enable docs
%define oname pygtk_git
%define qname gtk_git
%define _gtkdocdir %_datadir/gtk-doc/html

%define major 2.24
Name: python-module-%oname
Version: %major.1
Release: alt10.git20111002

Summary: Python bindings for the GTK+ widget set (from upstream git)

Group: Development/Python
License: LGPL
Url: http://www.pygtk.org/
Packager: Eugeny A. Rostovtsev (REAL) <real at altlinux.org>

# git://git.gnome.org/pygtk
Source: pygtk-%version.tar.bz2
Source1: pygtk_git.py

%setup_python_module %oname
%add_python_req_skip gdk

%py_provides argtypes_git
%py_provides %qname
%define pygobject_ver 2.28.3
%define pycairo_ver 1.8.11
%define gtk_version 2.24.4
%define glade_version 2.6.4

BuildPreReq: rpm-build-python python-devel gnome-common

# Automatically added by buildreq on Wed Feb 21 2007
BuildRequires: glibc-devel libglade-devel python-module-pycairo-devel
BuildPrereq: python-module-pygobject-devel python-modules-encodings xsltproc
BuildPreReq: libcairo-devel libatk-devel gdk-pixbuf-devel

# style.css from this package required to build documentation
BuildRequires: python-module-pygobject-devel-doc

BuildRequires: docbook-dtds docbook-style-xsl
BuildRequires: python-module-pycairo-devel >= %pycairo_ver
BuildRequires: libgtk+2-devel >= %gtk_version
BuildRequires: libglade2-devel >= %glade_version
BuildRequires: python-module-pygobject-devel >= %pygobject_ver
BuildRequires: rpm-build-compat
%{?_enable_numpy:BuildRequires: libnumpy-devel}
%{?_enable_docs:BuildRequires: python-module-sphinx-devel}

# Why we do not catch it automatically?
Requires: python-module-pycairo >= %pycairo_ver
Requires: python-module-pygobject >= %pygobject_ver

%description
PyGTK is an extension module for python that gives you access to the GTK+
widget set.  Just about anything you can write in C with GTK+ you can write
in python with PyGTK (within reason), but with all the benefits of python.


%package libglade
Summary: A wrapper for the libglade library for use with PyGTK
Group: Development/Python
Requires: %name = %version-%release libglade2
%py_provides libglade_git

%description libglade
This module contains a wrapper for the libglade library.  Libglade allows
a program to construct its user interface from an XML description, which
allows the programmer to keep the UI and program logic separate.

%package devel
Summary: files needed to build wrappers for GTK+ addon libraries
Group: Development/Python
Requires: %name = %version-%release
Requires: %name-devel-data = %version-%release

%description devel
This package contains files required to build wrappers for GTK+ addon
libraries so that they interoperate with pygtk.

%package devel-data
Summary: Data files needed to build wrappers for GTK+ addon libraries
Group: Development/Python
BuildArch: noarch

%description devel-data
This package contains data files required to build wrappers for GTK+
addon libraries so that they interoperate with pygtk.

%package demo
Summary: pygtk2 demo
Group: Development/Python

%description demo
This package contains pygtk2 demo

%if_enabled docs
%package doc
Summary: pygtk2 doc
Group: Development/Python
BuildArch: noarch

%description doc
This package contains pygtk2 doc

%package pickles
Summary: Pickles for pygtk2
Group: Development/Python

%description pickles
This package contains pickles for pygtk2.

%endif

%package tests
Summary: pygtk2 tests
Group: Development/Python
Requires: %name = %version-%release

%description tests
This package contains pygtk2 tests.


%prep
%setup

subst "s|@PYTHON@|%_bindir/env python|g" pygtk-codegen-2.0.in \
	examples/pygtk-demo/pygtk-demo.in

mv pygtk-codegen-2.0.in %oname-codegen-2.0.in
mv pygtk-2.0.pc.in %oname-2.0.pc.in

%if_enabled docs
%prepare_sphinx .
%endif

%build
%autoreconf
%configure --disable-static \
	%{subst_enable numpy} \
	%{subst_enable docs} \
	--enable-threads

%make_build

%if_enabled docs
%generate_pickles $PWD $PWD/docs/html %oname
%endif

%install
%makeinstall_std
install -d %buildroot%python_sitelibdir/gtk-2.0
mkdir -p %buildroot%_includedir/python%_python_version

#ifarch x86_64
#mv %buildroot%python_sitelibdir_noarch/gtk-2.0/* \
#	%buildroot%python_sitelibdir/gtk-2.0/
#endif
mv %buildroot%_includedir/pygtk-2.0 \
	%buildroot%_includedir/python%_python_version/%oname
subst "s|\${includedir}/pygtk-2.0|\${includedir}/python%_python_version/%oname|g" \
	%buildroot/%_pkgconfigdir/*.pc

# something broken if gobject still here
test -f %buildroot%python_sitelibdir/gtk-2.0/gobject.so && exit 1
# don't like x11 symbols due directfb
#objdump -t %buildroot%python_sitelibdir/gtk-2.0/gtk/_gtk.so | grep -i x11 && exit 1

# forking

mv %buildroot%python_sitelibdir/gtk-2.0/gtk \
	%buildroot%python_sitelibdir/gtk-2.0/%qname

cp -fR tests %buildroot%python_sitelibdir/gtk-2.0/tests_git
touch %buildroot%python_sitelibdir/gtk-2.0/tests_git/__init__.py

mv %buildroot%_bindir/pygtk-demo \
	%buildroot%_bindir/%oname-demo
mv %buildroot%_datadir/pygtk \
	%buildroot%_datadir/%oname
mv %buildroot%_libdir/pygtk \
	%buildroot%_libdir/%oname
mv %buildroot%_gtkdocdir/pygtk %buildroot%_gtkdocdir/%oname

install -p -m644 %SOURCE1 %buildroot%python_sitelibdir

# pickles

%if_enabled docs
install -d %buildroot%python_sitelibdir/%oname
cp -fR pickle %buildroot%python_sitelibdir/%oname/
%endif

%files
%doc AUTHORS NEWS README MAPPING ChangeLog* THREADS TODO
%python_sitelibdir/%oname.py*
%python_sitelibdir/gtk-2.0/*
%exclude %python_sitelibdir/gtk-2.0/%qname/glade.*
%exclude %python_sitelibdir/gtk-2.0/tests_git

%files demo
%_bindir/%oname-demo
%_libdir/%oname/

%files libglade
%python_sitelibdir/gtk-2.0/gtk_git/glade.*

%files devel
%_bindir/%oname-codegen-2.0
%python_includedir/pygtk_git/pygtk/
%_pkgconfigdir/pygtk*.pc

%files devel-data
%_datadir/%oname/

%files tests
%python_sitelibdir/gtk-2.0/tests_git

%if_enabled docs
%files doc
%_gtkdocdir/%oname/

%files pickles
%doc %python_sitelibdir/%oname
%python_sitelibdir/%oname/pickle
%endif

%changelog
