%define oname pyices

%def_without python3

Name: python-module-%oname
Version: 0.2
Release: alt1.git20140507
Summary: Python bindings for Yices SMT solver
License: Free
Group: Development/Python
Url: https://github.com/cheshire/pyices
Packager: Eugeny A. Rostovtsev (REAL) <real at altlinux.org>

# https://github.com/cheshire/pyices.git
Source: %name-%version.tar

BuildPreReq: libyices-devel
BuildPreReq: python-devel python-module-setuptools-tests
BuildPreReq: python-module-ctypesgen python-module-nose
%if_with python3
BuildRequires(pre): rpm-build-python3
BuildPreReq: python3-devel python3-module-setuptools-tests
BuildPreReq: python3-module-nose
BuildPreReq: python-tools-2to3
%endif

%py_provides %oname
%ifarch x86_64
Requires: libyices.so.2.3()(64bit)
%else
Requires: libyices.so.2.3
%endif

%description
Python bindings for Yices SMT solver. Works as a layer on top of C API,
on top of the layer generated by ctypesgen.

%package tests
Summary: Tests for %oname
Group: Development/Python
Requires: %name = %EVR

%description tests
Python bindings for Yices SMT solver. Works as a layer on top of C API,
on top of the layer generated by ctypesgen.

This package contains tests for %oname.

%if_with python3
%package -n python3-module-%oname
Summary: Python bindings for Yices SMT solver
Group: Development/Python3
%py3_provides %oname

%description -n python3-module-%oname
Python bindings for Yices SMT solver. Works as a layer on top of C API,
on top of the layer generated by ctypesgen.

%package -n python3-module-%oname-tests
Summary: Tests for %oname
Group: Development/Python3
Requires: python3-module-%oname = %EVR

%description -n python3-module-%oname-tests
Python bindings for Yices SMT solver. Works as a layer on top of C API,
on top of the layer generated by ctypesgen.

This package contains tests for %oname.
%endif

%prep
%setup

%ifarch x86_64
LIB_SUFF=64
%endif
sed -i "s|@64@|$LIB_SUFF|" setup.py

%install
export YICES_PATH=%prefix
%python_build_install

%if_with python3
cp -fR . ../python3
find ../python3 -type f -name '*.py' -exec 2to3 -w -n '{}' +
#pushd ../python3
#python3_build_install
#popd
%endif

%ifarch x86_64
mv %buildroot%_libexecdir %buildroot%_libdir
%endif

%check
nosetests -v
%if_with python3
pushd ../python3
nosetests3 -v
popd
%endif

%files
%doc *.md
%python_sitelibdir/*
%exclude %python_sitelibdir/*/tests

%files tests
%python_sitelibdir/*/tests

%if_with python3
%files -n python3-module-%oname
%doc *.md
%python3_sitelibdir/*
%exclude %python3_sitelibdir/*/tests

%files -n python3-module-%oname-tests
%python3_sitelibdir/*/tests
%endif

%changelog
