%define mpiimpl openmpi
%define mpidir %_libexecdir/%mpiimpl

%define oname pyipopt
Name: python-module-%oname
Version: 1.0
Release: alt2.git20140116
Summary: Python interface to Ipopt
License: Artistic License/GPL
Group: Development/Python
Url: https://github.com/xuy/pyipopt
Packager: Eugeny A. Rostovtsev (REAL) <real at altlinux.org>

# https://github.com/xuy/pyipopt.git
Source: %oname-%version.tar.gz

%setup_python_module %oname
BuildPreReq: python-devel libnumpy-devel libipopt-devel gcc-fortran
BuildPreReq: %mpiimpl-devel liblapack-devel

%description
Ipopt is a state-of-the-art optimization solver for nonlinear
optimization problems. Unfortunately, the only interface available is
C/C++ or Fortran. As Python becomes more popular these days, a connector
to python is necessary.

%package examples
Summary: Examples for Python interface to Ipopt
Group: Development/Python
BuildArch: noarch

%description examples
Ipopt is a state-of-the-art optimization solver for nonlinear
optimization problems. Unfortunately, the only interface available is
C/C++ or Fortran. As Python becomes more popular these days, a connector
to python is necessary.

%prep
%setup

%install
export OMPI_LDFLAGS="-Wl,--as-needed,-Rpath=%mpidir/lib -L%mpidir/lib"

%add_optflags -fno-strict-aliasing -I%_includedir/coin
%python_build_debug
%python_install

%files
%doc Changelog README.md
%python_sitelibdir/*

%files examples
%doc examples/*

%changelog
