%define module_name pyjsonrpc

%def_without python3

Name: python-module-%module_name
Version: 0.7.2
Release: alt1.git20150320

Summary: json-rpc package which implements JSON-RPC over HTTP

License: LGPL
Group: Development/Python
Url: http://json-rpc.org/wiki/python-json-rpc

# https://github.com/gerold-penz/python-jsonrpc.git
Source: %name-%version.tar

BuildArch: noarch

%setup_python_module %module_name
BuildPreReq: python-module-setuptools-tests python-module-bunch
BuildPreReq: python-modules-json
%if_with python3
BuildRequires(pre): rpm-build-python3
BuildPreReq: python3-module-setuptools-tests python3-module-bunch
BuildPreReq: python-tools-2to3
%endif

Obsoletes: python-module-jsonrpc < %EVR

%description
Simple Reference JSON-RPC Implementation for Django

%if_with python3
%package -n python3-module-%module_name
Summary: json-rpc package which implements JSON-RPC over HTTP
Group: Development/Python3

%description -n python3-module-%module_name
Simple Reference JSON-RPC Implementation for Django
%endif

%prep
%setup

%if_with python3
cp -fR . ../python3
find ../python3 -type f -name '*.py' -exec 2to3 -w -n '{}' +
%endif

%build
%python_build

%if_with python3
pushd ../python3
%python3_build
popd
%endif

%install
%python_install

%if_with python3
pushd ../python3
%python3_install
popd
%endif

%check
python setup.py test
%if_with python3
pushd ../python3
python3 setup.py test
popd
%endif

%files
%doc *.rst examples development
%python_sitelibdir/*

%if_with python3
%files -n python3-module-%module_name
%doc *.rst examples development
%python3_sitelibdir/*
%endif

%changelog
