%global _unpackaged_files_terminate_build 1
%define oname pytest

%def_with python3
%def_with docs

Name: python-module-%oname
Version: 3.2.1
Release: alt0.M80P.1
Summary: py.test, a simple and popular testing tool for Python
License: MIT
Group: Development/Python
Url: https://pypi.python.org/pypi/pytest

%py_requires py

BuildArch: noarch

# https://github.com/pytest-dev/pytest.git
Source: %name-%version.tar.gz
Patch1: %oname-%version-alt-docs.patch

BuildRequires(pre): rpm-build-python
BuildPreReq: python-module-setuptools python-module-hypothesis python-module-setuptools_scm
BuildRequires: git-core
%if_with python3
BuildRequires(pre): rpm-build-python3
BuildPreReq: python3-module-setuptools python3-module-hypothesis python3-module-setuptools_scm
%endif
%if_with docs
BuildRequires(pre): rpm-macros-sphinx
BuildPreReq: python-module-alabaster python-module-docutils python-module-html5lib python-module-objects.inv python-module-py
%endif

%global long_desc is a command line tool to collect, run and report about\
automated tests. It runs well on Linux, Windows and OSX and on Python\
2.4 through to 3.1 versions. It is used in many projects, ranging from\
running 10 thousands of tests to a few inlined tests on a command line\
script. As of version 1.2 you can also generate a\
no-dependency py.test-equivalent standalone script that you can\
distribute along with your application.

%description
py.test %long_desc

Install pytest package if you need the extra /usr/bin/pytest executable
in addition to the usual /usr/bin/py.test.

%package -n pytest
Summary: Additional executable for py.test
Group: Development/Python
# It simply has executables with the same filename:
Conflicts: python-module-logilab-common < 1.0.2-alt2.hg20150708

%description -n pytest
py.test is a simple and popular testing tool for Python.
It is packaged as python-module-%oname by ALT.

This package contains the extra /usr/bin/pytest executable
in addition to /usr/bin/py.test, which has always been packaged
before.

This separate package has been made to track the dependencies on this
additional executable.

%if_with python3

%package -n python3-module-%oname
Summary: py.test3, the simple and popular testing tool for Python 3
Group: Development/Python3
%py3_requires py
%add_python3_req_skip compiler
%add_python3_req_skip py.io
%add_python3_req_skip py.builtin

%description -n python3-module-%oname
py.test3 %long_desc

Install pytest3 package if you need the extra /usr/bin/pytest3 executable
in addition to the usual /usr/bin/py.test3
(which used to be /usr/bin/py.test-3.M).

%package -n pytest3
Summary: Additional executable for py.test3
Group: Development/Python3
# It simply has executables with the same filename:
Conflicts: python3-module-logilab-common < 1.0.2-alt2.hg20150708

%description -n pytest3
py.test3 is a simple and popular testing tool, the Python3 variant.
It is packaged as python3-module-%oname by ALT.

This package contains the extra /usr/bin/pytest3 executable
in addition to /usr/bin/py.test3, which has always been packaged
before (as /usr/bin/py.test-3.N).

This separate package has been made to track the dependencies on this
additional executable.

%endif

%package docs
Summary: Documentation for py.test
Group: Development/Documentation

%description docs
py.test is a command line tool to collect, run and report about
automated tests. It runs well on Linux, Windows and OSX and on Python
2.4 through to 3.1 versions. It is used in many projects, ranging from
running 10 thousands of tests to a few inlined tests on a command line
script. As of version 1.2 you can also generate a
no-dependency py.test-equivalent standalone script that you can
distribute along with your application.

This package contains documentation for py.test.

%package pickles
Summary: Pickles for py.test
Group: Development/Python

%description pickles
py.test is a command line tool to collect, run and report about
automated tests. It runs well on Linux, Windows and OSX and on Python
2.4 through to 3.1 versions. It is used in many projects, ranging from
running 10 thousands of tests to a few inlined tests on a command line
script. As of version 1.2 you can also generate a
no-dependency py.test-equivalent standalone script that you can
distribute along with your application.

This package contains pickles for py.test.

%prep
%setup
%patch1 -p1

git config --global user.email "darktemplar at altlinux.org"
git config --global user.name "darktemplar"
git init-db
git add . -A
git commit -a -m "%version"
git tag %version -m "%version"

%if_with python3
cp -a . -T ../python3
%endif

%if_with docs
%prepare_sphinx doc
ln -s ../objects.inv doc/en/
%endif

%build
%python_build
%if_with python3
pushd ../python3
%python3_build
popd
%endif

%if_with docs
export PYTHONPATH=%buildroot%python_sitelibdir
pushd doc/en
%make html
%make pickle
popd
%endif

%install
%if_with python3
pushd ../python3
%python3_install
mv %buildroot%_bindir/py.test -T %buildroot%_bindir/py.test3
mv %buildroot%_bindir/pytest -T %buildroot%_bindir/pytest3
popd
%endif

%python_install

%if_with docs
install -d %buildroot%python_sitelibdir/%oname
cp -R doc/en/_build/pickle -t %buildroot%python_sitelibdir/%oname/
%endif

%check
#python setup.py test
#if_with python3
#pushd ../python3
#python3 setup.py test
#popd
#endif

%files
%doc AUTHORS LICENSE *.rst
%_bindir/py.test
%python_sitelibdir/*
%if_with docs
%exclude %python_sitelibdir/%oname/pickle
%endif

%files -n pytest
%_bindir/pytest

%if_with docs

%files pickles
%python_sitelibdir/%oname/pickle

%files docs
%doc doc/en/_build/html/*

%endif

%if_with python3

%files -n python3-module-%oname
%doc AUTHORS LICENSE *.rst
%_bindir/py.test3
%python3_sitelibdir/*

%files -n pytest3
%_bindir/pytest3

%endif

%changelog
