%define oname pytest-diffeo

%def_with python3

Name: python-module-%oname
Version: 0.1.8
Release: alt1.git20141106.1
Summary: Common py.test support for Diffeo tests
License: MIT/X11
Group: Development/Python
Url: https://pypi.python.org/pypi/pytest-diffeo/
Packager: Eugeny A. Rostovtsev (REAL) <real at altlinux.org>

# https://github.com/diffeo/pytest-diffeo.git
Source: %name-%version.tar
BuildArch: noarch

BuildPreReq: python-devel python-module-setuptools-tests
%if_with python3
BuildRequires(pre): rpm-build-python3
BuildPreReq: python3-devel python3-module-setuptools-tests
BuildPreReq: python-tools-2to3
%endif

%py_provides pytest_diffeo

%description
If this package is installed, then you can run py.test with additional
command-line arguments --runperf, --runslow, -runload, or
-run-integration. Tests marked with @pytest.mark.performance,
@pytest.mark.slow, @pytest.mark.load, and pytest.mark.integration
respectively, will not be run unless the corresponding command-line
option is present.

This package also provides a redis_address fixture to get the location
of an external Redis installation. This must be provided via a
--redis-address command-line argument.

%package -n python3-module-%oname
Summary: Common py.test support for Diffeo tests
Group: Development/Python3
%py3_provides pytest_diffeo

%description -n python3-module-%oname
If this package is installed, then you can run py.test with additional
command-line arguments --runperf, --runslow, -runload, or
-run-integration. Tests marked with @pytest.mark.performance,
@pytest.mark.slow, @pytest.mark.load, and pytest.mark.integration
respectively, will not be run unless the corresponding command-line
option is present.

This package also provides a redis_address fixture to get the location
of an external Redis installation. This must be provided via a
--redis-address command-line argument.

%prep
%setup

sed -i 's|@VERSION@|%version|' setup.py

%if_with python3
cp -fR . ../python3
find ../python3 -type f -name '*.py' -exec 2to3 -w -n '{}' +
%endif

%build
%python_build_debug

%if_with python3
pushd ../python3
%python3_build_debug
popd
%endif

%install
%python_install

%if_with python3
pushd ../python3
%python3_install
popd
%endif

%check
python setup.py test
%if_with python3
pushd ../python3
python3 setup.py test
popd
%endif

%files
%doc *.rst
%python_sitelibdir/*

%if_with python3
%files -n python3-module-%oname
%doc *.rst
%python3_sitelibdir/*
%endif

%changelog
