%define oname pytest-multihost

%def_with python3

Name: python-module-%oname
Version: 0.4
Release: alt1.git20141209.1.1
Summary: Utility for writing multi-host tests for pytest
License: GPLv3
Group: Development/Python
Url: https://pypi.python.org/pypi/pytest-multihost
Packager: Eugeny A. Rostovtsev (REAL) <real at altlinux.org>

# https://git.fedorahosted.org/git/python-pytest-multihost.git
Source: %name-%version.tar
BuildArch: noarch

#BuildPreReq: python-modules-json
#BuildPreReq: python-devel python-module-setuptools-tests
#BuildPreReq: python-module-yaml python-module-paramiko
%if_with python3
BuildRequires(pre): rpm-build-python3
#BuildPreReq: python3-devel python3-module-setuptools-tests
#BuildPreReq: python3-module-yaml python3-module-paramiko
%endif

%py_provides pytest_multihost
%py_requires yaml paramiko

# Automatically added by buildreq on Thu Jan 28 2016 (-bi)
# optimized out: python-base python-devel python-module-pytest python-module-setuptools python-modules python-modules-compiler python-modules-ctypes python-modules-email python-modules-encodings python-modules-unittest python3 python3-base python3-module-pytest python3-module-setuptools
BuildRequires: python-module-ecdsa python-module-pycrypto python-module-setuptools-tests python-module-yaml python3-module-ecdsa python3-module-pycrypto python3-module-setuptools-tests python3-module-yaml rpm-build-python3

%description
A pytest plugin for multi-host testing.

%package -n python3-module-%oname
Summary: Utility for writing multi-host tests for pytest
Group: Development/Python3
%py3_provides pytest_multihost
%py3_requires yaml paramiko

%description -n python3-module-%oname
A pytest plugin for multi-host testing.

%prep
%setup

%if_with python3
cp -fR . ../python3
%endif

%build
%python_build_debug

%if_with python3
pushd ../python3
%python3_build_debug
popd
%endif

%install
%python_install

%if_with python3
pushd ../python3
%python3_install
popd
%endif

%check
python setup.py test
%if_with python3
pushd ../python3
python3 setup.py test
popd
%endif

%files
%doc *.rst
%python_sitelibdir/*

%if_with python3
%files -n python3-module-%oname
%doc *.rst
%python3_sitelibdir/*
%endif

%changelog
