Name: python-module-pyvorbis
Version: 1.4
Release: alt2

Summary: A Python module for the the Ogg/Vorbis library
Group: Development/Python
License: GPL
Url: http://www.andrewchatham.com/pyogg

Packager: Python Development Team <python@packages.altlinux.org>

%setup_python_module pyvorbis

Source: %url/download/%modulename-%version.tar.bz2
Patch: pyvorbisfile.diff

%define libvorbis_ver 1.0
%define pyogg_ver 1.3

Requires: libvorbis >= %libvorbis_ver
Requires: python-module-pyogg >= %pyogg_ver

Provides: pyvorbis = %version
Obsoletes: pyvorbis

BuildPreReq: libvorbis-devel >= %libvorbis_ver
BuildPreReq: python-module-pyogg-devel >= %pyogg_ver

# Automatically added by buildreq on Mon Jul 19 2004
BuildRequires: libogg-devel libvorbis-devel python-devel python-module-pyogg-devel python-modules-encodings

%description
%name is a wrapper for libvorbis, a compressed audio format library.

%package devel
Summary: %name headers and example programs
Group: Development/Python
BuildArch: noarch
Requires: %name = %version-%release
Provides: pyvorbis-devel = %version
Obsoletes: pyvorbis-devel

%description devel
%name is a wrapper for libvorbis, a compressed audio format library.

Install %name-devel if you need the API documentation and example
programs.

%define python_libdir %_libdir/python%_python_version
%define python_site_packages_dir %python_libdir/site-packages
%define python_includedir %_includedir/python%_python_version

%prep
%setup -q -n %modulename-%version
%patch -p1

%build
export CFLAGS="%optflags"
python config_unix.py --prefix /usr
%python_build

%install
%python_install --optimize=2

mkdir -p %buildroot%python_includedir/%modulename
install -m644 src/*.h %buildroot%python_includedir/%modulename
chmod -x test/*

%files
%python_site_packages_dir/ogg/*.so
%python_site_packages_dir/*.egg-info
%doc AUTHORS ChangeLog README

%files devel
%python_includedir/%modulename
%doc test/*

%changelog
