%define oname pyxattr

%def_with python3

Name: python-module-%oname
Version: 0.5.3
Release: alt3.1

Summary: A python module for accessing filesystem Extended Attributes

License: LGPLv2.1
Group: Development/Python
Url: http://pyxattr.sourceforge.net/

# https://github.com/iustin/pyxattr.git
Source: %name-%version.tar

%setup_python_module %oname

BuildPreReq: libattr-devel python-module-sphinx-devel
%if_with python3
BuildRequires(pre): rpm-build-python3
BuildPreReq: python3-devel
%endif

%description
This is the pyxattr module, a Python extension module which gives access
to the extended attributes for filesystem objects available in some
operating systems.

%package -n python3-module-%oname
Summary: A python module for accessing filesystem Extended Attributes
Group: Development/Python3

%description -n python3-module-%oname
This is the pyxattr module, a Python extension module which gives access
to the extended attributes for filesystem objects available in some
operating systems.

%prep
%setup

%if_with python3
cp -fR . ../python3
%endif

%prepare_sphinx .
ln -s ../objects.inv doc/

%build
%python_build_debug

%if_with python3
pushd ../python3
%python3_build_debug
popd
%endif

%install
%python_install

%if_with python3
pushd ../python3
%python3_install
popd
%endif

export PYTHONPATH=%buildroot%python_sitelibdir
%make doc

%files
%python_sitelibdir/*
%doc NEWS README doc/html

%if_with python3
%files -n python3-module-%oname
%python3_sitelibdir/*
%doc NEWS README doc/html
%endif

%changelog
