%define oname repoze.filesafe

%def_with python3

Name: python-module-%oname
Version: 2.1
Release: alt2.gi20140506.1
Summary: Transaction-aware file creation
License: BSD
Group: Development/Python
Url: https://github.com/repoze/repoze.filesafe
Packager: Eugeny A. Rostovtsev (REAL) <real at altlinux.org>

# https://github.com/repoze/repoze.filesafe.git
Source: %name-%version.tar

BuildPreReq: python-devel python-module-setuptools
%if_with python3
BuildRequires(pre): rpm-build-python3
BuildPreReq: python3-devel python3-module-setuptools
%endif

%py_requires repoze transaction zope.interface

%description
repoze.filesafe provides utilities methods to handle creation
of files on the filesystem safely by integrating with the ZODB package's
transaction manager.  It can be used in combination with repoze.tm (or
repoze.tm2) for use in WSGI environments.

%package -n python3-module-%oname
Summary: Transaction-aware file creation
Group: Development/Python3
%py3_requires repoze transaction zope.interface

%description -n python3-module-%oname
repoze.filesafe provides utilities methods to handle creation
of files on the filesystem safely by integrating with the ZODB package's
transaction manager.  It can be used in combination with repoze.tm (or
repoze.tm2) for use in WSGI environments.

%package -n python3-module-%oname-tests
Summary: Tests for repoze.filesafe
Group: Development/Python3
Requires: python3-module-%oname = %version-%release

%description -n python3-module-%oname-tests
repoze.filesafe provides utilities methods to handle creation
of files on the filesystem safely by integrating with the ZODB package's
transaction manager.  It can be used in combination with repoze.tm (or
repoze.tm2) for use in WSGI environments.

This package contains tests for repoze.filesafe.

%package tests
Summary: Tests for repoze.filesafe
Group: Development/Python
Requires: %name = %version-%release

%description tests
repoze.filesafe provides utilities methods to handle creation
of files on the filesystem safely by integrating with the ZODB package's
transaction manager.  It can be used in combination with repoze.tm (or
repoze.tm2) for use in WSGI environments.

This package contains tests for repoze.filesafe.

%prep
%setup

%if_with python3
cp -fR . ../python3
%endif

%build
%python_build

%if_with python3
pushd ../python3
%python3_build
popd
%endif

%install
%python_install
%ifarch x86_64
install -d %buildroot%python_sitelibdir
mv %buildroot%python_sitelibdir_noarch/* \
	%buildroot%python_sitelibdir/
%endif

%if_with python3
pushd ../python3
%python3_install
popd
%ifarch x86_64
install -d %buildroot%python3_sitelibdir
mv %buildroot%python3_sitelibdir_noarch/* \
	%buildroot%python3_sitelibdir/
%endif
%endif

%files
%doc *.txt docs/*.rst
%python_sitelibdir/*
%exclude %python_sitelibdir/*.pth
%exclude %python_sitelibdir/*/*/test*

%files tests
%python_sitelibdir/*/*/test*

%if_with python3
%files -n python3-module-%oname
%doc *.txt docs/*.rst
%python3_sitelibdir/*
%exclude %python3_sitelibdir/*.pth
%exclude %python3_sitelibdir/*/*/test*
%exclude %python3_sitelibdir/*/*/*/test*

%files -n python3-module-%oname-tests
%python3_sitelibdir/*/*/test*
%python3_sitelibdir/*/*/*/test*
%endif

%changelog
