%define oname repoze.mailin

%def_with python3

Name: python-module-%oname
Version: 0.4
Release: alt2.git20120326.1
Summary: Map inbound e-mail onto application-defined handlers
License: BSD
Group: Development/Python
Url: https://github.com/repoze/repoze.mailin
Packager: Eugeny A. Rostovtsev (REAL) <real at altlinux.org>

# https://github.com/repoze/repoze.mailin.git
Source: %name-%version.tar

BuildPreReq: python-devel python-module-setuptools
%if_with python3
BuildRequires(pre): rpm-build-python3
BuildPreReq: python3-devel python3-module-setuptools
BuildPreReq: python-tools-2to3
%endif

%py_provides %oname
%py_requires repoze zope.interface

%description
This package provides a framework for mapping inbound e-mail onto
application-defined handlers.

%package -n python3-module-%oname
Summary: Map inbound e-mail onto application-defined handlers
Group: Development/Python3
%py3_provides %oname
%py3_requires repoze zope.interface

%description -n python3-module-%oname
This package provides a framework for mapping inbound e-mail onto
application-defined handlers.

%package -n python3-module-%oname-tests
Summary: Tests for repoze.mailin
Group: Development/Python3
Requires: python3-module-%oname = %version-%release

%description -n python3-module-%oname-tests
This package provides a framework for mapping inbound e-mail onto
application-defined handlers.

This package contains tests for repoze.mailin.

%package tests
Summary: Tests for repoze.mailin
Group: Development/Python
Requires: %name = %version-%release

%description tests
This package provides a framework for mapping inbound e-mail onto
application-defined handlers.

This package contains tests for repoze.mailin.

%prep
%setup

%if_with python3
cp -fR . ../python3
find ../python3 -type f -name '*.py' -exec 2to3 -w -n '{}' +
%endif

%build
%python_build

%if_with python3
pushd ../python3
%python3_build
popd
%endif

%install
%if_with python3
pushd ../python3
%python3_install
popd
%ifarch x86_64
install -d %buildroot%python3_sitelibdir
mv %buildroot%python3_sitelibdir_noarch/* \
	%buildroot%python3_sitelibdir/
%endif
pushd %buildroot%_bindir
for i in $(ls); do
	mv $i $i.py3
done
popd
%endif

%python_install
%ifarch x86_64
install -d %buildroot%python_sitelibdir
mv %buildroot%python_sitelibdir_noarch/* \
	%buildroot%python_sitelibdir/
%endif

%files
%doc *.txt docs/index.rst
%_bindir/*
%if_with python3
%exclude %_bindir/*.py3
%endif
%python_sitelibdir/*
%exclude %python_sitelibdir/*.pth
%exclude %python_sitelibdir/*/*/tests

%files tests
%python_sitelibdir/*/*/tests

%if_with python3
%files -n python3-module-%oname
%doc *.txt docs/index.rst
%_bindir/*.py3
%python3_sitelibdir/*
%exclude %python3_sitelibdir/*.pth
%exclude %python3_sitelibdir/*/*/tests

%files -n python3-module-%oname-tests
%python3_sitelibdir/*/*/tests
%endif

%changelog
