%define oname repoze.postoffice

%def_with python3

Name: python-module-%oname
Version: 0.24
Release: alt2.1
Summary: Provides central depot for incoming mail for use by applications
License: BSD
Group: Development/Python
Url: http://pypi.python.org/pypi/repoze.postoffice/
Packager: Eugeny A. Rostovtsev (REAL) <real at altlinux.org>

Source: %name-%version.tar

BuildPreReq: python-devel python-module-setuptools
%if_with python3
BuildRequires(pre): rpm-build-python3
BuildPreReq: python3-devel python3-module-setuptools
BuildPreReq: python-tools-2to3
%endif

%py_requires repoze ZODB3 repoze.zodbconn

%description
`repoze.postoffice` provides a centralized depot for collecting incoming
email for consumption by multiple applications.  Incoming mail is sorted
into queues according to rules with the expectation that each
application will then consume its own queue.  Each queue is a
first-in-first-out (FIFO) queue, so messages are processed in the order
received.

ZODB is used for storage and is also used to provide the client
interface.  `repoze.postoffice` clients create a ZODB connection and
manipulate models.  This makes consuming the message queue in the
context of a transaction, relatively simple.

%package -n python3-module-%oname
Summary: Provides central depot for incoming mail for use by applications
Group: Development/Python3
%py3_requires repoze ZODB3 repoze.zodbconn

%description -n python3-module-%oname
`repoze.postoffice` provides a centralized depot for collecting incoming
email for consumption by multiple applications.  Incoming mail is sorted
into queues according to rules with the expectation that each
application will then consume its own queue.  Each queue is a
first-in-first-out (FIFO) queue, so messages are processed in the order
received.

ZODB is used for storage and is also used to provide the client
interface.  `repoze.postoffice` clients create a ZODB connection and
manipulate models.  This makes consuming the message queue in the
context of a transaction, relatively simple.

%package -n python3-module-%oname-tests
Summary: Tests for repoze.postoffice
Group: Development/Python3
Requires: python3-module-%oname = %version-%release

%description -n python3-module-%oname-tests
`repoze.postoffice` provides a centralized depot for collecting incoming
email for consumption by multiple applications.  Incoming mail is sorted
into queues according to rules with the expectation that each
application will then consume its own queue.  Each queue is a
first-in-first-out (FIFO) queue, so messages are processed in the order
received.

ZODB is used for storage and is also used to provide the client
interface.  `repoze.postoffice` clients create a ZODB connection and
manipulate models.  This makes consuming the message queue in the
context of a transaction, relatively simple.

This package contains tests for repoze.postoffice.

%package tests
Summary: Tests for repoze.postoffice
Group: Development/Python
Requires: %name = %version-%release

%description tests
`repoze.postoffice` provides a centralized depot for collecting incoming
email for consumption by multiple applications.  Incoming mail is sorted
into queues according to rules with the expectation that each
application will then consume its own queue.  Each queue is a
first-in-first-out (FIFO) queue, so messages are processed in the order
received.

ZODB is used for storage and is also used to provide the client
interface.  `repoze.postoffice` clients create a ZODB connection and
manipulate models.  This makes consuming the message queue in the
context of a transaction, relatively simple.

This package contains tests for repoze.postoffice.

%prep
%setup

%if_with python3
cp -fR . ../python3
find ../python3 -type f -name '*.py' -exec 2to3 -w -n '{}' +
%endif

%build
%python_build

%if_with python3
pushd ../python3
%python3_build
popd
%endif

%install
%if_with python3
pushd ../python3
%python3_install
popd
%ifarch x86_64
install -d %buildroot%python3_sitelibdir
mv %buildroot%python3_sitelibdir_noarch/* \
	%buildroot%python3_sitelibdir/
%endif
pushd %buildroot%_bindir
for i in $(ls); do
	mv $i $i.py3
done
popd
%endif

%python_install
%ifarch x86_64
install -d %buildroot%python_sitelibdir
mv %buildroot%python_sitelibdir_noarch/* \
	%buildroot%python_sitelibdir/
%endif

%files
%doc *.rst docs/*.rst
%_bindir/*
%if_with python3
%exclude %_bindir/*.py3
%endif
%python_sitelibdir/*
%exclude %python_sitelibdir/*.pth
%exclude %python_sitelibdir/*/*/tests

%files tests
%python_sitelibdir/*/*/tests

%if_with python3
%files -n python3-module-%oname
%doc *.rst docs/*.rst
%_bindir/*.py3
%python3_sitelibdir/*
%exclude %python3_sitelibdir/*.pth
%exclude %python3_sitelibdir/*/*/tests

%files -n python3-module-%oname-tests
%python3_sitelibdir/*/*/tests
%endif

%changelog
