%define _unpackaged_files_terminate_build 1
%define pkgname requests
%def_with python3
%def_disable check

Name:           python-module-requests
Version:        2.18.4
Release:        alt1
Summary:        HTTP library, written in Python, for human beings
Group:          Development/Python

License:        ASL 2.0
URL:            https://pypi.io/project/requests
Source0:        %pkgname-%version.tar
# Explicitly use the system certificates in ca-certificates.
# https://bugzilla.redhat.com/show_bug.cgi?id=904614
Patch0:         python-requests-system-cert-bundle.patch
# Remove an unnecessary reference to a bundled compat lib in urllib3
# Some discussion with upstream:
# - https://twitter.com/sigmavirus24/status/529816751651819520
# - https://github.com/kennethreitz/requests/issues/1811
# - https://github.com/kennethreitz/requests/pull/1812
Patch1:         dont-import-OrderedDict-from-urllib3.patch

BuildArch:      noarch

BuildRequires:  python-devel python-modules-json
BuildRequires:  python-module-chardet
BuildRequires:  python-module-urllib3 >= 1.13.1
BuildRequires:  python-module-idna
%{?_enable_check:BuildRequires: python-module-httpbin}
BuildRequires:  python-module-setuptools-tests

Requires:       ca-certificates
Requires:       python-module-chardet
Requires:       python-module-urllib3 >= 1.13.1
%py_requires json

%description
Most existing Python modules for sending HTTP requests are extremely verbose and
cumbersome. Python's built-in urllib2 module provides most of the HTTP
capabilities you should need, but the API is thoroughly broken. This library is
designed to make HTTP requests easy for developers.

%if_with python3
%package -n python3-module-%pkgname
Summary: HTTP library, written in Python, for human beings
Group:   Development/Python3
BuildRequires(pre): rpm-build-python3
BuildRequires:  python3-devel
BuildRequires:  python3-module-chardet
BuildRequires:  python3-module-urllib3 >= 1.13.1
BuildRequires:  python3-module-idna
%{?_enable_check:BuildRequires: python3-module-httpbin}
BuildRequires:  python3-module-setuptools-tests
Requires:       ca-certificates
Requires:       python3-module-chardet
Requires:       python3-module-urllib3 >= 1.13.1
%py3_requires json

%description -n python3-module-%pkgname
Most existing Python modules for sending HTTP requests are extremely verbose and
cumbersome. Python's built-in urllib2 module provides most of the HTTP
capabilities you should need, but the API is thoroughly broken. This library is
designed to make HTTP requests easy for developers.
%endif

%prep
%setup -n requests-%{version}

%patch0 -p1
%patch1 -p1

# Unbundle the certificate bundle from mozilla.
rm -rf requests/cacert.pem

%if_with python3
rm -rf ../python3
cp -a . ../python3
%endif

%build
%python_build
%if_with python3
pushd ../python3
%python3_build
popd
%endif

%install
%python_install

%if_with python3
pushd ../python3
%python3_install
popd
%endif

%files
%doc AUTHORS.rst CODE_OF_CONDUCT.md CONTRIBUTING.md HISTORY.rst README.rst
%python_sitelibdir/*

%if_with python3
%files -n python3-module-%pkgname
%doc AUTHORS.rst CODE_OF_CONDUCT.md CONTRIBUTING.md HISTORY.rst README.rst
%python3_sitelibdir/*
%endif

%changelog
