%define oname robotframework-lint

%def_without python3

Name: python-module-%oname
Version: 0.5
Release: alt1.git20150205
Summary: Static analysis tool for robotframework plain text files
License: ASLv2.0
Group: Development/Python
Url: https://pypi.python.org/pypi/robotframework-lint
Packager: Eugeny A. Rostovtsev (REAL) <real at altlinux.org>

# https://github.com/boakley/robotframework-lint.git
Source: %name-%version.tar
BuildArch: noarch

BuildPreReq: python-devel python-module-setuptools-tests
BuildPreReq: python-module-robotframework
%if_with python3
BuildRequires(pre): rpm-build-python3
BuildPreReq: python3-devel python3-module-setuptools-tests
BuildPreReq: python3-module-robotframework
BuildPreReq: python-tools-2to3
%endif

%py_provides rflint

%description
Linter for robot framework plain text files.

This is a static analysis tool for robot framework plain text files.

%if_with python3
%package -n python3-module-%oname
Summary: Static analysis tool for robotframework plain text files
Group: Development/Python3
%py3_provides rflint

%description -n python3-module-%oname
Linter for robot framework plain text files.

This is a static analysis tool for robot framework plain text files.
%endif

%prep
%setup

%if_with python3
cp -fR . ../python3
find ../python3 -type f -name '*.py' -exec 2to3 -w -n '{}' +
%endif

%build
%python_build_debug

%if_with python3
pushd ../python3
%python3_build_debug
popd
%endif

%install
%if_with python3
pushd ../python3
%python3_build_debug
popd
pushd %buildroot%_bindir
for i in $(ls); do
	mv $i $i.py3
done
popd
%endif

%python_install

%check
python setup.py test
%if_with python3
pushd ../python3
python3 setup.py test
popd
%endif

%files
%doc *.md
%_bindir/*
%if_with python3
%exclude %_bindir/*.py3
%endif
%python_sitelibdir/*

%if_with python3
%files -n python3-module-%oname
%doc *.md
%_bindir/*.py3
%python3_sitelibdir/*
%endif

%changelog
