%define oname routes

%def_with python3

Name: python-module-%oname
Version: 2.1
Release: alt2.git20150117.1
Summary: Routing Recognition and Generation Tools
License: BSD
Group: Development/Python
Url: http://routes.groovie.org/
Packager: Eugeny A. Rostovtsev (REAL) <real at altlinux.org>

# git://github.com/bbangert/routes
Source: %oname-%version.tar.gz
BuildArch: noarch

Requires: python-module-repoze.lru

BuildRequires(pre): rpm-build-python
BuildPreReq: python-devel python-module-setuptools
BuildPreReq: python-module-sphinx-devel python-module-Pygments
BuildPreReq: python-module-repoze.lru python-module-webob
%if_with python3
BuildRequires(pre): rpm-build-python3
BuildPreReq: python3-devel python3-module-setuptools
%endif

%description
Routes is a Python re-implementation of the Rails routes system for
mapping URLs to application actions, and conversely to generate URLs.
Routes makes it easy to create pretty and concise URLs that are RESTful
with little effort.

Routes allows conditional matching based on domain, cookies, HTTP
method, or a custom function. Sub-domain support is built in. Routes
comes with an extensive unit test suite.

%package -n python3-module-%oname
Summary: Routing Recognition and Generation Tools
Group: Development/Python3
Requires: python3-module-repoze.lru

%description -n python3-module-%oname
Routes is a Python re-implementation of the Rails routes system for
mapping URLs to application actions, and conversely to generate URLs.
Routes makes it easy to create pretty and concise URLs that are RESTful
with little effort.

Routes allows conditional matching based on domain, cookies, HTTP
method, or a custom function. Sub-domain support is built in. Routes
comes with an extensive unit test suite.

%package doc
Summary: Documentation for Routing Recognition and Generation Tools
Group: Development/Documentation
BuildArch: noarch

%description doc
Routes is a Python re-implementation of the Rails routes system for
mapping URLs to application actions, and conversely to generate URLs.
Routes makes it easy to create pretty and concise URLs that are RESTful
with little effort.

This package contains documentation for Routes.

%package pickles
Summary: Pickles for Routing Recognition and Generation Tools
Group: Development/Python

%description pickles
Routes is a Python re-implementation of the Rails routes system for
mapping URLs to application actions, and conversely to generate URLs.
Routes makes it easy to create pretty and concise URLs that are RESTful
with little effort.

This package contains pickles for Routes.

%prep
%setup

%if_with python3
cp -fR . ../python3
%endif

%build
%python_build

%if_with python3
pushd ../python3
%python3_build
popd
%endif

%install
%python_install

%if_with python3
pushd ../python3
%python3_install
popd
%endif

export PYTHONPATH=%buildroot%python_sitelibdir
pushd docs

install -d %buildroot%_docdir/%name
popd

%files
%doc CHANGELOG LICENSE README TODO
%python_sitelibdir/*

%files doc
%_docdir/%name


%if_with python3
%files -n python3-module-%oname
%doc CHANGELOG LICENSE README TODO
%python3_sitelibdir/*
%endif

%changelog
