%define oname scikit-image

%def_with python3
%def_disable docs

Name: python-module-%oname
Version: 0.12
Release: alt1.dev.git20150413.1.1
Summary: Image processing routines for SciPy
License: BSD
Group: Development/Python
Url: https://pypi.python.org/pypi/scikit-image/
Packager: Eugeny A. Rostovtsev (REAL) <real at altlinux.org>

# https://github.com/scikit-image/scikit-image.git
Source: %name-%version.tar

#BuildPreReq: python-devel python-module-setuptools-tests
#BuildPreReq: python-module-Cython python-module-matplotlib
#BuildPreReq: python-module-scipy libnumpy-devel
#BuildPreReq: python-module-six python-module-networkx
#BuildPreReq: python-module-Pillow
#BuildPreReq: python-module-sphinx-devel python-module-numpydoc xvfb-run
%if_with python3
BuildRequires(pre): rpm-build-python3
#BuildPreReq: python3-devel python3-module-setuptools-tests
#BuildPreReq: python3-module-Cython python3-module-matplotlib
#BuildPreReq: python3-module-scipy libnumpy-py3-devel
#BuildPreReq: python3-module-six python3-module-networkx
#BuildPreReq: python3-module-Pillow
%endif

%py_provides skimage
%py_requires numpy scipy networkx matplotlib

BuildRequires(pre): rpm-macros-sphinx
# Automatically added by buildreq on Thu Jan 28 2016 (-bi)
# optimized out: elfutils ipython ipython3 libnumpy-devel python-base python-devel python-module-PyStemmer python-module-Pygments python-module-babel python-module-cffi python-module-chardet python-module-coverage python-module-cryptography python-module-cssselect python-module-docutils python-module-enum34 python-module-functools32 python-module-future python-module-genshi python-module-greenlet python-module-ipykernel python-module-ipyparallel python-module-ipython_genutils python-module-jinja2 python-module-jsonschema python-module-jupyter_client python-module-jupyter_core python-module-matplotlib python-module-mpmath python-module-nbconvert python-module-nbformat python-module-ndg-httpsclient python-module-ntlm python-module-numpy python-module-pexpect python-module-ptyprocess python-module-pyasn1 python-module-pycares python-module-pycurl python-module-pygobject3 python-module-pyparsing python-module-pytest python-module-pytz python-module-scipy python-module-setuptools python-module-snowballstemmer python-module-sphinx python-module-terminado python-module-tornado_xstatic python-module-traitlets python-module-wx3.0 python-module-xstatic python-module-xstatic-term.js python-module-yaml python-module-zmq python-module-zope.interface python-modules python-modules-compiler python-modules-ctypes python-modules-email python-modules-encodings python-modules-json python-modules-unittest python-modules-wsgiref python-modules-xml python3 python3-base python3-dev python3-module-Pygments python3-module-babel python3-module-cffi python3-module-chardet python3-module-coverage python3-module-cssselect python3-module-docutils python3-module-future python3-module-genshi python3-module-greenlet python3-module-ipykernel python3-module-ipyparallel python3-module-ipython_genutils python3-module-jinja2 python3-module-jsonschema python3-module-jupyter_client python3-module-jupyter_core python3-module-matplotlib python3-module-nbconvert python3-module-nbformat python3-module-numpy python3-module-pexpect python3-module-ptyprocess python3-module-pycares python3-module-pycparser python3-module-pygobject3 python3-module-pyparsing python3-module-pytest python3-module-pytz python3-module-scipy python3-module-setuptools python3-module-snowballstemmer python3-module-sphinx python3-module-terminado python3-module-tornado_xstatic python3-module-traitlets python3-module-xstatic python3-module-xstatic-term.js python3-module-yaml python3-module-yieldfrom.http.client python3-module-yieldfrom.requests python3-module-yieldfrom.urllib3 python3-module-zmq python3-module-zope python3-module-zope.interface
BuildRequires: libnumpy-py3-devel python-module-Cython python-module-html5lib python-module-networkx-core python-module-notebook python-module-numpy-testing python-module-objects.inv python-module-pydot python-module-pygraphviz python-module-setuptools-tests python3-module-Cython python3-module-html5lib python3-module-networkx-core python3-module-notebook python3-module-numpy-testing python3-module-pydot python3-module-pygraphviz python3-module-setuptools-tests rpm-build-python3

%description
Image processing algorithms for SciPy, including IO, morphology,
filtering, warping, color manipulation, object detection, etc.

%package tests
Summary: Tests for %oname
Group: Development/Python
Requires: %name = %EVR

%description tests
Image processing algorithms for SciPy, including IO, morphology,
filtering, warping, color manipulation, object detection, etc.

This package contains tests for %oname.

%package -n python3-module-%oname
Summary: Image processing routines for SciPy
Group: Development/Python3
%py3_provides skimage
%py3_requires numpy scipy networkx matplotlib

%description -n python3-module-%oname
Image processing algorithms for SciPy, including IO, morphology,
filtering, warping, color manipulation, object detection, etc.

%package -n python3-module-%oname-tests
Summary: Tests for %oname
Group: Development/Python3
Requires: python3-module-%oname = %EVR

%description -n python3-module-%oname-tests
Image processing algorithms for SciPy, including IO, morphology,
filtering, warping, color manipulation, object detection, etc.

This package contains tests for %oname.

%package pickles
Summary: Pickles for %oname
Group: Development/Python

%description pickles
Image processing algorithms for SciPy, including IO, morphology,
filtering, warping, color manipulation, object detection, etc.

This package contains pickles for %oname.

%package docs
Summary: Documentation for %oname
Group: Development/Documentation
BuildArch: noarch

%description docs
Image processing algorithms for SciPy, including IO, morphology,
filtering, warping, color manipulation, object detection, etc.

This package contains documentation for %oname.

%prep
%setup

%if_with python3
cp -fR . ../python3
%endif

%prepare_sphinx doc
ln -s ../objects.inv doc/source/

%build
%add_optflags -fno-strict-aliasing
%python_build_debug

%if_with python3
pushd ../python3
%python3_build_debug
popd
%endif

%install
%if_with python3
pushd ../python3
%python3_install
popd
pushd %buildroot%_bindir
for i in $(ls); do
	mv $i $i.py3
done
popd
%endif

%python_install

%if_enabled docs
export PYTHONPATH=%buildroot%python_sitelibdir
xvfb-run make -C doc pickle
xvfb-run make -C doc html

install -d %buildroot%python_sitelibdir/%oname
cp -fR doc/build/pickle %buildroot%python_sitelibdir/%oname/
%endif

%if_disabled check
rm -f requirements.txt
%endif

%check
python setup.py test
rm -f requirements.txt
%if_with python3
pushd ../python3
python3 setup.py test
popd
%endif

%files
%doc *.txt *.md
%_bindir/*
%if_with python3
%exclude %_bindir/*.py3
%endif
%python_sitelibdir/*
%if_enabled docs
%exclude %python_sitelibdir/*/pickle
%endif
%exclude %python_sitelibdir/*/*/test*
%exclude %python_sitelibdir/*/*/*/test*

%files tests
%python_sitelibdir/*/*/test*
%python_sitelibdir/*/*/*/test*

%if_enabled docs
%files pickles
%python_sitelibdir/*/pickle

%files docs
%doc doc/build/html doc/examples viewer_examples
%else
%files docs
%doc doc/examples viewer_examples
%endif

%if_with python3
%files -n python3-module-%oname
%doc *.txt *.md
%_bindir/*.py3
%python3_sitelibdir/*
%exclude %python3_sitelibdir/*/*/test*
%exclude %python3_sitelibdir/*/*/*/test*
%exclude %python3_sitelibdir/*/*/*/*/test*

%files -n python3-module-%oname-tests
%python3_sitelibdir/*/*/test*
%python3_sitelibdir/*/*/*/test*
%python3_sitelibdir/*/*/*/*/test*
%endif

%changelog
