# Note: mkl is a Intel Compiler thing
%def_disable snapshot

BuildRequires(pre): rpm-build-python
%define python_noarch %python_sitelibdir_noarch
%define modname scipy
%define ver_major 0.19

%def_enable docs
%def_with python3

Name: python-module-%modname
Version: %ver_major.1
Release: alt0.M80P.1

Summary: SciPy is the library of scientific codes

License: BSD
Group: Development/Python
Url: http://www.scipy.org/

%setup_python_module %modname
Requires: %python_noarch

#add_python_req_skip swig2_ext symeig vtk
%add_python_req_skip distutils

%if_disabled snapshot
Source: https://github.com/%modname/%modname/releases/download/v%version/%modname-%version.tar.xz
%else
#VCS git://github.com/scipy/scipy.git
Source: %modname-%version.tar
%endif
Source1: site.cfg

#BuildPreReq: python-module-sympy python-module-scipy git
#BuildPreReq: python-module-numpy python-module-matplotlib-sphinxext
#BuildPreReq: python-module-numdifftools
#BuildPreReq: libsuitesparse-devel swig /proc rpm-macros-make
#BuildPreReq: python-module-sphinx-devel
#BuildPreReq: python-module-Pygments
#BuildPreReq: python-module-matplotlib
#BuildPreReq: boost-python-devel
%if_enabled docs
#BuildPreReq: python-module-matplotlib-sphinxext python-module-numpydoc
#BuildPreReq: %py_dependencies scikits.statsmodels.docs.sphinxext
%endif

BuildRequires(pre): rpm-macros-make
BuildRequires(pre): rpm-macros-sphinx
BuildPreReq: gcc-c++ gcc-fortran git-core liblapack-devel libnumpy-devel libnumpy-py3-devel python-module-Cython python-module-Pyrex python-module-alabaster python-module-html5lib python-module-ipyparallel python-module-matplotlib-sphinxext python-module-numdifftools python-module-numpy-testing python-module-objects.inv python-module-sphinx-pickles python3-module-Cython python3-module-html5lib python3-module-jinja2-tests  python3-module-numpy-testing rpm-build-python3 time vixie-cron

#BuildRequires: gcc-c++ gcc-fortran liblapack-devel python-module-Pyrex
#BuildRequires: python-module-ctypes libnumpy-devel python-modules-curses
#BuildRequires: libsuitesparse-devel python-module-Cython
%if_with python3
BuildRequires(pre): rpm-build-python3
#BuildRequires: python3-devel python3-module-distribute
#BuildPreReq: python3-module-Pygments libnumpy-py3-devel
#BuildPreReq: python-tools-2to3 python3-module-Cython
#BuildPreReq: boost-python3-devel
%endif

%description
SciPy is the library of scientific codes built on top of NumPy.

%if_with python3
%package -n python3-module-%modname
Summary: SciPy is the library of scientific codes (Python 3)
Group: Development/Python3
Requires: %python3_sitelibdir_noarch
%add_python3_req_skip _min_spanning_tree _shortest_path _tools
%add_python3_req_skip _traversal sympy
%add_python3_req_skip distutils

%description -n python3-module-%modname
SciPy is the library of scientific codes built on top of NumPy.

%package -n python3-module-%modname-devel
Summary: Development files of SciPy (Python 3)
Group: Development/Python3
Requires: python3-module-%modname = %version-%release
Requires: python3-devel libnumpy-py3-devel

%description -n python3-module-%modname-devel
SciPy is the library of scientific codes built on top of NumPy.

This package contains development files of SciPy.

%package -n python3-module-%modname-tests
Summary: Tests and examples for SciPy (Python 3)
Group: Development/Python3
Requires: python3-module-%modname = %version-%release
%add_python3_req_skip ext_tools inline_tools swig2_ext symeig
%add_python3_req_skip md5 vtk wxPython
%add_python3_req_skip pylab

%description -n python3-module-%modname-tests
SciPy is the library of scientific codes built on top of NumPy.

This package contains tests and examples for SciPy.
%endif

%package devel
Summary: Development files of SciPy
Group: Development/Python
Requires: %name = %version-%release
Requires: python-devel libnumpy-devel

%description devel
SciPy is the library of scientific codes built on top of NumPy.

This package contains development files of SciPy.

%package tests
Summary: Tests and examples for SciPy
Group: Development/Python
Requires: %name = %version-%release
%add_python_req_skip ext_tools inline_tools swig2_ext symeig vtk weave

%description tests
SciPy is the library of scientific codes built on top of NumPy.

This package contains tests and examples for SciPy.

%if_enabled docs
%package pickles
Summary: Pickles for SciPy
Group: Development/Python

%description pickles
SciPy is the library of scientific codes built on top of NumPy.

This package contains pickles for SciPy.

%package doc-html
Summary: Documentation for SciPy in HTML
Group: Development/Documentation
BuildArch: noarch

%description doc-html
SciPy is the library of scientific codes built on top of NumPy.

This package contains development documentation for SciPy in HTML.

%package doc-pdf
Summary: Documentation for SciPy in PDF
Group: Development/Documentation

%description doc-pdf
SciPy is the library of scientific codes built on top of NumPy.

This package contains development documentation for SciPy in PDF.
%endif

%prep
%setup -n %modname-%version
install -p -m644 %SOURCE1 .
sed -i 's|@LIBDIR@|%_libdir|g' site.cfg doc/Makefile
sed -i 's|@PYVER@|%_python_version|g' doc/Makefile

%if_with python3
rm -rf ../python3
cp -a . ../python3
sed -i 's|@PYSUFF@|3|' ../python3/site.cfg
%endif

sed -i 's|@PYSUFF@||' site.cfg

# Sphinx
%if_enabled docs
sed -i "s|@TOP@|$PWD|" \
	doc/source/conf.py
sed -i 's|@SPHINXREL@|%sphinx_rel|' \
	doc/source/conf.py
%prepare_sphinx .
cp conf.py objects.inv doc/
%endif

mkdir -p ~/.matplotlib
cp %python_sitelibdir/matplotlib/mpl-data/matplotlibrc \
	~/.matplotlib/
sed -i 's|^\(backend\).*|\1 : Agg|' ~/.matplotlib/matplotlibrc

%build
%add_optflags -I%_includedir/suitesparse -fno-strict-aliasing %optflags_shared
%python_build_debug build_ext build_py build_clib \
	config_fc --fcompiler=gnu95

%if_with python3
pushd ../python3
%python3_build_debug build_ext build_py build_clib \
	config_fc --fcompiler=gnu95
popd
%endif

%install
%python_install install_lib install_headers \
	install_data config_fc


# headers
pushd %modname
for i in $(find ./ -name '*.h'); do
    dir=$(echo $i|sed 's|\(.*\)/.*|\1|')
    install -d %buildroot%_includedir/%modname/$dir
    install -p -m644 $i \
	%buildroot%_includedir/%modname/$dir
done
popd

install -p -m644 $(find ./ -name fortranobject.h) \
	%buildroot%_includedir/%modname

%if_with python3
pushd ../python3
%python3_install install_lib install_headers \
	install_data config_fc
find %buildroot%python3_sitelibdir -type f -exec \
	sed -i 's|#! %_bindir/env python|#!%_bindir/python3|' -- '{}' + ||:
find %buildroot%python3_sitelibdir -type f -exec \
	sed -i 's|#!%_bindir/env python|#!%_bindir/python3|' -- '{}' + ||:

# headers
pushd %modname
for i in $(find ./ -name '*.h'); do
    dir=$(echo $i|sed 's|\(.*\)/.*|\1|')
    install -d %buildroot%_includedir/%modname-py3/$dir
    install -p -m644 $i \
	%buildroot%_includedir/%modname-py3/$dir
done
popd


install -p -m644 $(find ./ -name fortranobject.h) \
	%buildroot%_includedir/%modname-py3
popd
pushd %buildroot%python3_sitelibdir/%modname/sparse/csgraph
for i in $(ls *.so); do
	ln -s %python3_sitelibdir/%modname/sparse/csgraph/$i \
		%buildroot%python3_sitelibdir/
done
popd
%endif

# docs
%if_enabled docs
export PYTHONPATH=%buildroot%python_sitelibdir
%add_optflags -I%buildroot%_includedir -I%_includedir/suitesparse
PATH=$PATH:%python_sitelibdir/scikits/statsmodels/docs/sphinxext
export PATH=$PATH:%python_sitelibdir/scikits/statsmodels/docs
pushd doc
%make_ext html pickle
popd

install -d %buildroot%_docdir/%name
cp -fR doc/build/html %buildroot%_docdir/%name/
install -p -m644 LICENSE.txt doc/README.txt THANKS.txt HACKING.rst.txt \
	%buildroot%_docdir/%name/

# pickles
cp -fR doc/build/pickle %buildroot%python_sitelibdir/%modname/
%endif

# tests
for i in $(find ./ -name tests -type d) \
	$(find ./ -name examples -type d)
do
	touch $i/__init__.py
done

rm -f %buildroot%python_sitelibdir/scipy/pickle/generated/scipy-stats-rv_discrete-1.py

%find_lang %name

#check
#pushd %buildroot%python_sitelibdir
#python -c "import scipy ; scipy.test()"
#popd
#rm -f %buildroot%python_sitelibdir/*.so \
#	%buildroot%python_sitelibdir/*.cpp

%files -f %name.lang
%python_sitelibdir/*
%exclude %python_sitelibdir/%modname/*/tests
%exclude %python_sitelibdir/%modname/*/*/tests
%exclude %python_sitelibdir/%modname/*/*/*/tests
%exclude %python_sitelibdir/%modname/*/*/*/*/tests
%if_enabled docs
%exclude %python_sitelibdir/%modname/pickle
%endif

%files tests
%python_sitelibdir/%modname/*/tests
%python_sitelibdir/%modname/*/*/tests
%python_sitelibdir/%modname/*/*/*/tests
%python_sitelibdir/%modname/*/*/*/*/tests

%files devel
%_includedir/*
%if_with python3
%exclude %_includedir/%modname-py3
%endif

%if_with python3
%files -n python3-module-%modname -f %name.lang
%python3_sitelibdir/*
#exclude %python3_sitelibdir/%modname/*/examples
%exclude %python3_sitelibdir/%modname/*/tests
%exclude %python3_sitelibdir/%modname/*/*/tests
%exclude %python3_sitelibdir/%modname/*/*/*/tests
%exclude %python3_sitelibdir/%modname/*/*/*/*/tests

%files -n python3-module-%modname-tests
#python3_sitelibdir/%modname/*/examples
%python3_sitelibdir/%modname/*/tests
%python3_sitelibdir/%modname/*/*/tests
%python3_sitelibdir/%modname/*/*/*/tests
%python3_sitelibdir/%modname/*/*/*/*/tests

%files -n python3-module-%modname-devel
%_includedir/%modname-py3
%endif

%if_enabled docs
%files doc-html
#dir %_docdir/%name
#_docdir/%name/html
%_docdir/%name

#files doc-pdf
#dir %_docdir/%name
#_docdir/%name/pdf

%files pickles
%python_sitelibdir/%modname/pickle
%endif

%changelog
