%define oname selenium

%def_with python3

Name: python-module-%oname
Version: 2.47.0
Release: alt2.M80P.1
Summary: Python bindings for Selenium
License: ASL
Group: Development/Python
Url: https://pypi.python.org/pypi/selenium/
Packager: Eugeny A. Rostovtsev (REAL) <real at altlinux.org>

Source: %name-%version.tar
Patch: selenium-use-without-bundled-libs.patch

BuildPreReq: python-devel python-module-setuptools-tests
%if_with python3
BuildRequires(pre): rpm-build-python3
BuildPreReq: python3-devel python3-module-setuptools-tests
%endif

%description
Python language bindings for Selenium WebDriver.

The selenium package is used automate web browser interaction from
Python.

%package -n python3-module-%oname
Summary: Python bindings for Selenium
Group: Development/Python3

%description -n python3-module-%oname
Python language bindings for Selenium WebDriver.

The selenium package is used automate web browser interaction from
Python.

%prep
%setup
%patch -p2

%if_with python3
cp -fR . ../python3
%endif

%build
%python_build_debug

%if_with python3
pushd ../python3
%python3_build_debug
popd
%endif

%install
%python_install

%if_with python3
pushd ../python3
%python3_install
popd
%endif

%ifarch x86_64
mv %buildroot%_libexecdir %buildroot%_libdir
%endif

find %buildroot -type f -name '*.so' -exec rm -f '{}' +

%check
python setup.py test
%if_with python3
pushd ../python3
python3 setup.py test
popd
%endif

%files
%python_sitelibdir/*

%if_with python3
%files -n python3-module-%oname
%python3_sitelibdir/*
%endif

%changelog
