%define modulename setuptools

%def_with python3

Name: python-module-%modulename
Epoch: 1
Version: 18.5
Release: alt0.M80P.1

Summary: Python Distutils Enhancements
License: PSF/ZPL
Group: Development/Python
URL: http://pypi.python.org/pypi/setuptools

# Source-url: https://pypi.io/packages/source/s/%modulename/%modulename-%version.tar.gz
Source: %modulename.tar

Patch0: 0001-Don-t-remove-setuptools.tests-from-the-installed-pac.patch
Patch1: 0001-command-test.py-skip-install_requires-and-tests_requ.patch
Patch2: 0002-dist.py-skip-checking-the-existence-of-system-PKG-IN.patch

BuildArch: noarch

BuildRequires(pre): rpm-build-python
BuildPreReq: python-devel
# For more precise reqs:
%python_req_hier

Provides: python-module-distribute = %epoch:%version-%release

Provides: %name-tests = %epoch:%version-%release
Obsoletes: %name-tests <= 1:18.1-alt4
Obsoletes: python-module-distribute <= 0.6.35-alt1
%if_with python3
BuildRequires(pre): rpm-build-python3
BuildPreReq: python3-devel
# For more precise reqs:
%python3_req_hier
%endif

%description
Setuptools is a collection of enhancements to the Python distutils
that allow you to more easily build and distribute Python packages,
especially ones that have dependencies on other packages.

%package docs
Summary: Documentation for Setuptools
Group: Development/Documentation
Provides: python-module-distribute-docs = %epoch:%version-%release

%description docs
Distribute is intended to replace Setuptools as the standard method for
working with Python module distributions.

This package contains documentation for Distribute.

%if_with python3
%package -n python3-module-%modulename
Summary: Python Distutils Enhancements
Group: Development/Python3
Provides: python3-module-distribute = %epoch:%version-%release

Provides: python3-module-%modulename-tests = %epoch:%version-%release
Obsoletes: python3-module-%modulename-tests <= 1:18.1-alt4

%description -n python3-module-%modulename
Setuptools is a collection of enhancements to the Python distutils
that allow you to more easily build and distribute Python packages,
especially ones that have dependencies on other packages.
%endif

%prep
%setup -n %modulename
%patch0 -p2
%patch1 -p2
%patch2 -p2

%if_with python3
rm -rf ../python3
cp -a . ../python3
%endif

%build
%python_build
#python setup.py test

%if_with python3
pushd ../python3
%python3_build
popd
%endif

%install
mkdir -p %buildroot%python_sitelibdir
%python_install

%if_with python3
pushd ../python3
%python3_install
popd
%endif

rm -f %buildroot%_bindir/easy_install
ln -s easy_install-%_python_version %buildroot%_bindir/easy_install
%if_with python3
ln -s easy_install-%_python3_version %buildroot%_bindir/easy_install3
%endif

%files
%doc *.txt
%_bindir/easy_install
%_bindir/easy_install-%_python_version
%python_sitelibdir/_markerlib/
%python_sitelibdir/pkg_resources/
%dir %python_sitelibdir/%modulename/
%python_sitelibdir/%modulename/*.*
%python_sitelibdir/%modulename/command/
%python_sitelibdir/%modulename/tests/
%python_sitelibdir/easy_install.*
%python_sitelibdir/%modulename-%version-*.egg-info

%files docs
%doc docs/*.txt

%if_with python3
%files -n python3-module-%modulename
%_bindir/easy_install3
%_bindir/easy_install-%_python3_version
%python3_sitelibdir/__pycache__/*
%python3_sitelibdir/_markerlib/
%python3_sitelibdir/pkg_resources/
%dir %python3_sitelibdir/%modulename/
%python3_sitelibdir/%modulename/__pycache__/
%python3_sitelibdir/%modulename/*.*
%python3_sitelibdir/%modulename/command/
%python3_sitelibdir/%modulename/tests/
%python3_sitelibdir/easy_install.*
%python3_sitelibdir/%modulename-%version-*.egg-info
%endif

%changelog
